package schedulerx3

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateJob invokes the schedulerx3.UpdateJob API synchronously
func (client *Client) UpdateJob(request *UpdateJobRequest) (response *UpdateJobResponse, err error) {
	response = CreateUpdateJobResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateJobWithChan invokes the schedulerx3.UpdateJob API asynchronously
func (client *Client) UpdateJobWithChan(request *UpdateJobRequest) (<-chan *UpdateJobResponse, <-chan error) {
	responseChan := make(chan *UpdateJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateJobWithCallback invokes the schedulerx3.UpdateJob API asynchronously
func (client *Client) UpdateJobWithCallback(request *UpdateJobRequest, callback func(response *UpdateJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateJobResponse
		var err error
		defer close(result)
		response, err = client.UpdateJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateJobRequest is the request struct for api UpdateJob
type UpdateJobRequest struct {
	*requests.RpcRequest
	MseSessionId          string                     `position:"Query" name:"MseSessionId"`
	ExecutorBlockStrategy requests.Integer           `position:"Body" name:"ExecutorBlockStrategy"`
	Timezone              string                     `position:"Body" name:"Timezone"`
	RouteStrategy         requests.Integer           `position:"Body" name:"RouteStrategy"`
	Description           string                     `position:"Body" name:"Description"`
	AttemptInterval       requests.Integer           `position:"Body" name:"AttemptInterval"`
	StartTime             requests.Integer           `position:"Body" name:"StartTime"`
	JobId                 requests.Integer           `position:"Body" name:"JobId"`
	AppName               string                     `position:"Body" name:"AppName"`
	NoticeContacts        *[]UpdateJobNoticeContacts `position:"Body" name:"NoticeContacts"  type:"Json"`
	NoticeConfig          UpdateJobNoticeConfig      `position:"Body" name:"NoticeConfig"  type:"Struct"`
	Calendar              string                     `position:"Body" name:"Calendar"`
	DataOffset            requests.Integer           `position:"Body" name:"DataOffset"`
	MaxAttempt            requests.Integer           `position:"Body" name:"MaxAttempt"`
	ClusterId             string                     `position:"Body" name:"ClusterId"`
	Priority              requests.Integer           `position:"Body" name:"Priority"`
	TimeExpression        string                     `position:"Body" name:"TimeExpression"`
	Name                  string                     `position:"Body" name:"Name"`
	XAttrs                string                     `position:"Body" name:"XAttrs"`
	MaxConcurrency        requests.Integer           `position:"Body" name:"MaxConcurrency"`
	TimeType              requests.Integer           `position:"Body" name:"TimeType"`
	Parameters            string                     `position:"Body" name:"Parameters"`
	JobHandler            string                     `position:"Body" name:"JobHandler"`
	CleanMode             string                     `position:"Body" name:"CleanMode"`
}

// UpdateJobNoticeContacts is a repeated param struct in UpdateJobRequest
type UpdateJobNoticeContacts struct {
	ContactType string `name:"ContactType"`
	Name        string `name:"Name"`
}

// UpdateJobNoticeConfig is a repeated param struct in UpdateJobRequest
type UpdateJobNoticeConfig struct {
	TimeoutKillEnable string `name:"TimeoutKillEnable"`
	FailEnable        string `name:"FailEnable"`
	WebhookIsAtAll    string `name:"webhookIsAtAll"`
	SuccessNotice     string `name:"SuccessNotice"`
	FailLimitTimes    string `name:"FailLimitTimes"`
	SendChannel       string `name:"SendChannel"`
	TimeoutEnable     string `name:"TimeoutEnable"`
	MissWorkerEnable  string `name:"MissWorkerEnable"`
	Timeout           string `name:"Timeout"`
}

// UpdateJobResponse is the response struct for api UpdateJob
type UpdateJobResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateUpdateJobRequest creates a request to invoke UpdateJob API
func CreateUpdateJobRequest() (request *UpdateJobRequest) {
	request = &UpdateJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SchedulerX3", "2024-06-24", "UpdateJob", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateJobResponse creates a response to parse from UpdateJob response
func CreateUpdateJobResponse() (response *UpdateJobResponse) {
	response = &UpdateJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
