package sasti

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeFileReport invokes the sasti.DescribeFileReport API synchronously
func (client *Client) DescribeFileReport(request *DescribeFileReportRequest) (response *DescribeFileReportResponse, err error) {
	response = CreateDescribeFileReportResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeFileReportWithChan invokes the sasti.DescribeFileReport API asynchronously
func (client *Client) DescribeFileReportWithChan(request *DescribeFileReportRequest) (<-chan *DescribeFileReportResponse, <-chan error) {
	responseChan := make(chan *DescribeFileReportResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeFileReport(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeFileReportWithCallback invokes the sasti.DescribeFileReport API asynchronously
func (client *Client) DescribeFileReportWithCallback(request *DescribeFileReportRequest, callback func(response *DescribeFileReportResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeFileReportResponse
		var err error
		defer close(result)
		response, err = client.DescribeFileReport(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeFileReportRequest is the request struct for api DescribeFileReport
type DescribeFileReportRequest struct {
	*requests.RpcRequest
	SourceIp    string `position:"Query" name:"SourceIp"`
	Field       string `position:"Query" name:"Field"`
	ServiceLang string `position:"Query" name:"ServiceLang"`
	FileHash    string `position:"Query" name:"FileHash"`
}

// DescribeFileReportResponse is the response struct for api DescribeFileReport
type DescribeFileReportResponse struct {
	*responses.BaseResponse
	Intelligences string `json:"Intelligences" xml:"Intelligences"`
	RequestId     string `json:"RequestId" xml:"RequestId"`
	FileHash      string `json:"FileHash" xml:"FileHash"`
	ThreatTypes   string `json:"ThreatTypes" xml:"ThreatTypes"`
	Basic         string `json:"Basic" xml:"Basic"`
	ThreatLevel   string `json:"ThreatLevel" xml:"ThreatLevel"`
	Sandbox       string `json:"Sandbox" xml:"Sandbox"`
}

// CreateDescribeFileReportRequest creates a request to invoke DescribeFileReport API
func CreateDescribeFileReportRequest() (request *DescribeFileReportRequest) {
	request = &DescribeFileReportRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sasti", "2020-05-12", "DescribeFileReport", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeFileReportResponse creates a response to parse from DescribeFileReport response
func CreateDescribeFileReportResponse() (response *DescribeFileReportResponse) {
	response = &DescribeFileReportResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
