package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetIOCs invokes the sas.GetIOCs API synchronously
func (client *Client) GetIOCs(request *GetIOCsRequest) (response *GetIOCsResponse, err error) {
	response = CreateGetIOCsResponse()
	err = client.DoAction(request, response)
	return
}

// GetIOCsWithChan invokes the sas.GetIOCs API asynchronously
func (client *Client) GetIOCsWithChan(request *GetIOCsRequest) (<-chan *GetIOCsResponse, <-chan error) {
	responseChan := make(chan *GetIOCsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetIOCs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetIOCsWithCallback invokes the sas.GetIOCs API asynchronously
func (client *Client) GetIOCsWithCallback(request *GetIOCsRequest, callback func(response *GetIOCsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetIOCsResponse
		var err error
		defer close(result)
		response, err = client.GetIOCs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetIOCsRequest is the request struct for api GetIOCs
type GetIOCsRequest struct {
	*requests.RpcRequest
	Date     string `position:"Query" name:"Date"`
	Type     string `position:"Query" name:"Type"`
	SourceIp string `position:"Query" name:"SourceIp"`
}

// GetIOCsResponse is the response struct for api GetIOCs
type GetIOCsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"data" xml:"data"`
}

// CreateGetIOCsRequest creates a request to invoke GetIOCs API
func CreateGetIOCsRequest() (request *GetIOCsRequest) {
	request = &GetIOCsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "GetIOCs", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetIOCsResponse creates a response to parse from GetIOCs response
func CreateGetIOCsResponse() (response *GetIOCsResponse) {
	response = &GetIOCsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
