package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeBackupFiles invokes the sas.DescribeBackupFiles API synchronously
func (client *Client) DescribeBackupFiles(request *DescribeBackupFilesRequest) (response *DescribeBackupFilesResponse, err error) {
	response = CreateDescribeBackupFilesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeBackupFilesWithChan invokes the sas.DescribeBackupFiles API asynchronously
func (client *Client) DescribeBackupFilesWithChan(request *DescribeBackupFilesRequest) (<-chan *DescribeBackupFilesResponse, <-chan error) {
	responseChan := make(chan *DescribeBackupFilesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeBackupFiles(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeBackupFilesWithCallback invokes the sas.DescribeBackupFiles API asynchronously
func (client *Client) DescribeBackupFilesWithCallback(request *DescribeBackupFilesRequest, callback func(response *DescribeBackupFilesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeBackupFilesResponse
		var err error
		defer close(result)
		response, err = client.DescribeBackupFiles(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeBackupFilesRequest is the request struct for api DescribeBackupFiles
type DescribeBackupFilesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Uuid            string           `position:"Query" name:"Uuid"`
	Path            string           `position:"Query" name:"Path"`
	SnapshotHash    string           `position:"Query" name:"SnapshotHash"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	PageSize        string           `position:"Query" name:"PageSize"`
	CurrentPage     string           `position:"Query" name:"CurrentPage"`
}

// DescribeBackupFilesResponse is the response struct for api DescribeBackupFiles
type DescribeBackupFilesResponse struct {
	*responses.BaseResponse
	RequestId   string       `json:"RequestId" xml:"RequestId"`
	PageInfo    PageInfo     `json:"PageInfo" xml:"PageInfo"`
	BackupFiles []BrowseFile `json:"BackupFiles" xml:"BackupFiles"`
}

// CreateDescribeBackupFilesRequest creates a request to invoke DescribeBackupFiles API
func CreateDescribeBackupFilesRequest() (request *DescribeBackupFilesRequest) {
	request = &DescribeBackupFilesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeBackupFiles", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeBackupFilesResponse creates a response to parse from DescribeBackupFiles response
func CreateDescribeBackupFilesResponse() (response *DescribeBackupFilesResponse) {
	response = &DescribeBackupFilesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
