package sas_api

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeHitRateColumn invokes the sas_api.DescribeHitRateColumn API synchronously
// api document: https://help.aliyun.com/api/sas-api/describehitratecolumn.html
func (client *Client) DescribeHitRateColumn(request *DescribeHitRateColumnRequest) (response *DescribeHitRateColumnResponse, err error) {
	response = CreateDescribeHitRateColumnResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeHitRateColumnWithChan invokes the sas_api.DescribeHitRateColumn API asynchronously
// api document: https://help.aliyun.com/api/sas-api/describehitratecolumn.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeHitRateColumnWithChan(request *DescribeHitRateColumnRequest) (<-chan *DescribeHitRateColumnResponse, <-chan error) {
	responseChan := make(chan *DescribeHitRateColumnResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeHitRateColumn(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeHitRateColumnWithCallback invokes the sas_api.DescribeHitRateColumn API asynchronously
// api document: https://help.aliyun.com/api/sas-api/describehitratecolumn.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeHitRateColumnWithCallback(request *DescribeHitRateColumnRequest, callback func(response *DescribeHitRateColumnResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeHitRateColumnResponse
		var err error
		defer close(result)
		response, err = client.DescribeHitRateColumn(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeHitRateColumnRequest is the request struct for api DescribeHitRateColumn
type DescribeHitRateColumnRequest struct {
	*requests.RpcRequest
	EndDate   string           `position:"Query" name:"EndDate"`
	SourceIp  string           `position:"Query" name:"SourceIp"`
	HitDay    requests.Integer `position:"Query" name:"HitDay"`
	StartDate string           `position:"Query" name:"StartDate"`
	ApiType   requests.Integer `position:"Query" name:"ApiType"`
}

// DescribeHitRateColumnResponse is the response struct for api DescribeHitRateColumn
type DescribeHitRateColumnResponse struct {
	*responses.BaseResponse
	RequestId string                        `json:"RequestId" xml:"RequestId"`
	TimeScope TimeScope                     `json:"TimeScope" xml:"TimeScope"`
	Items     []ItemInDescribeHitRateColumn `json:"Items" xml:"Items"`
}

// CreateDescribeHitRateColumnRequest creates a request to invoke DescribeHitRateColumn API
func CreateDescribeHitRateColumnRequest() (request *DescribeHitRateColumnRequest) {
	request = &DescribeHitRateColumnRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas-api", "2017-07-05", "DescribeHitRateColumn", "sas-api", "openAPI")
	return
}

// CreateDescribeHitRateColumnResponse creates a response to parse from DescribeHitRateColumn response
func CreateDescribeHitRateColumnResponse() (response *DescribeHitRateColumnResponse) {
	response = &DescribeHitRateColumnResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
