package resourcesharing

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AcceptResourceShareInvitation invokes the resourcesharing.AcceptResourceShareInvitation API synchronously
func (client *Client) AcceptResourceShareInvitation(request *AcceptResourceShareInvitationRequest) (response *AcceptResourceShareInvitationResponse, err error) {
	response = CreateAcceptResourceShareInvitationResponse()
	err = client.DoAction(request, response)
	return
}

// AcceptResourceShareInvitationWithChan invokes the resourcesharing.AcceptResourceShareInvitation API asynchronously
func (client *Client) AcceptResourceShareInvitationWithChan(request *AcceptResourceShareInvitationRequest) (<-chan *AcceptResourceShareInvitationResponse, <-chan error) {
	responseChan := make(chan *AcceptResourceShareInvitationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AcceptResourceShareInvitation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AcceptResourceShareInvitationWithCallback invokes the resourcesharing.AcceptResourceShareInvitation API asynchronously
func (client *Client) AcceptResourceShareInvitationWithCallback(request *AcceptResourceShareInvitationRequest, callback func(response *AcceptResourceShareInvitationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AcceptResourceShareInvitationResponse
		var err error
		defer close(result)
		response, err = client.AcceptResourceShareInvitation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AcceptResourceShareInvitationRequest is the request struct for api AcceptResourceShareInvitation
type AcceptResourceShareInvitationRequest struct {
	*requests.RpcRequest
	ResourceShareInvitationId string `position:"Query" name:"ResourceShareInvitationId"`
}

// AcceptResourceShareInvitationResponse is the response struct for api AcceptResourceShareInvitation
type AcceptResourceShareInvitationResponse struct {
	*responses.BaseResponse
	RequestId               string                  `json:"RequestId" xml:"RequestId"`
	ResourceShareInvitation ResourceShareInvitation `json:"ResourceShareInvitation" xml:"ResourceShareInvitation"`
}

// CreateAcceptResourceShareInvitationRequest creates a request to invoke AcceptResourceShareInvitation API
func CreateAcceptResourceShareInvitationRequest() (request *AcceptResourceShareInvitationRequest) {
	request = &AcceptResourceShareInvitationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceSharing", "2020-01-10", "AcceptResourceShareInvitation", "ressharing", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAcceptResourceShareInvitationResponse creates a response to parse from AcceptResourceShareInvitation response
func CreateAcceptResourceShareInvitationResponse() (response *AcceptResourceShareInvitationResponse) {
	response = &AcceptResourceShareInvitationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
