package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpgradeDBInstanceMajorVersion invokes the rds.UpgradeDBInstanceMajorVersion API synchronously
func (client *Client) UpgradeDBInstanceMajorVersion(request *UpgradeDBInstanceMajorVersionRequest) (response *UpgradeDBInstanceMajorVersionResponse, err error) {
	response = CreateUpgradeDBInstanceMajorVersionResponse()
	err = client.DoAction(request, response)
	return
}

// UpgradeDBInstanceMajorVersionWithChan invokes the rds.UpgradeDBInstanceMajorVersion API asynchronously
func (client *Client) UpgradeDBInstanceMajorVersionWithChan(request *UpgradeDBInstanceMajorVersionRequest) (<-chan *UpgradeDBInstanceMajorVersionResponse, <-chan error) {
	responseChan := make(chan *UpgradeDBInstanceMajorVersionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpgradeDBInstanceMajorVersion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpgradeDBInstanceMajorVersionWithCallback invokes the rds.UpgradeDBInstanceMajorVersion API asynchronously
func (client *Client) UpgradeDBInstanceMajorVersionWithCallback(request *UpgradeDBInstanceMajorVersionRequest, callback func(response *UpgradeDBInstanceMajorVersionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpgradeDBInstanceMajorVersionResponse
		var err error
		defer close(result)
		response, err = client.UpgradeDBInstanceMajorVersion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpgradeDBInstanceMajorVersionRequest is the request struct for api UpgradeDBInstanceMajorVersion
type UpgradeDBInstanceMajorVersionRequest struct {
	*requests.RpcRequest
	ResourceOwnerId       requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DBInstanceStorage     requests.Integer `position:"Query" name:"DBInstanceStorage"`
	ClientToken           string           `position:"Query" name:"ClientToken"`
	ZoneIdSlave1          string           `position:"Query" name:"ZoneIdSlave1"`
	ZoneIdSlave2          string           `position:"Query" name:"ZoneIdSlave2"`
	SwitchTimeMode        string           `position:"Query" name:"SwitchTimeMode"`
	SwitchOver            string           `position:"Query" name:"SwitchOver"`
	ResourceGroupId       string           `position:"Query" name:"ResourceGroupId"`
	CollectStatMode       string           `position:"Query" name:"CollectStatMode"`
	DBInstanceDescription string           `position:"Query" name:"DBInstanceDescription"`
	SwitchTime            string           `position:"Query" name:"SwitchTime"`
	DBInstanceId          string           `position:"Query" name:"DBInstanceId"`
	DBInstanceStorageType string           `position:"Query" name:"DBInstanceStorageType"`
	Period                string           `position:"Query" name:"Period"`
	ResourceOwnerAccount  string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount          string           `position:"Query" name:"OwnerAccount"`
	OwnerId               requests.Integer `position:"Query" name:"OwnerId"`
	UsedTime              string           `position:"Query" name:"UsedTime"`
	DBInstanceClass       string           `position:"Query" name:"DBInstanceClass"`
	VSwitchId             string           `position:"Query" name:"VSwitchId"`
	PrivateIpAddress      string           `position:"Query" name:"PrivateIpAddress"`
	VPCId                 string           `position:"Query" name:"VPCId"`
	ZoneId                string           `position:"Query" name:"ZoneId"`
	PayType               string           `position:"Query" name:"PayType"`
	InstanceNetworkType   string           `position:"Query" name:"InstanceNetworkType"`
	TargetMajorVersion    string           `position:"Query" name:"TargetMajorVersion"`
}

// UpgradeDBInstanceMajorVersionResponse is the response struct for api UpgradeDBInstanceMajorVersion
type UpgradeDBInstanceMajorVersionResponse struct {
	*responses.BaseResponse
	DBInstanceId     string `json:"DBInstanceId" xml:"DBInstanceId"`
	RequestId        string `json:"RequestId" xml:"RequestId"`
	Port             string `json:"Port" xml:"Port"`
	ConnectionString string `json:"ConnectionString" xml:"ConnectionString"`
	OrderId          string `json:"OrderId" xml:"OrderId"`
	TaskId           int64  `json:"TaskId" xml:"TaskId"`
}

// CreateUpgradeDBInstanceMajorVersionRequest creates a request to invoke UpgradeDBInstanceMajorVersion API
func CreateUpgradeDBInstanceMajorVersionRequest() (request *UpgradeDBInstanceMajorVersionRequest) {
	request = &UpgradeDBInstanceMajorVersionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "UpgradeDBInstanceMajorVersion", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpgradeDBInstanceMajorVersionResponse creates a response to parse from UpgradeDBInstanceMajorVersion response
func CreateUpgradeDBInstanceMajorVersionResponse() (response *UpgradeDBInstanceMajorVersionResponse) {
	response = &UpgradeDBInstanceMajorVersionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
