package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateYouhuiForOrder invokes the rds.CreateYouhuiForOrder API synchronously
func (client *Client) CreateYouhuiForOrder(request *CreateYouhuiForOrderRequest) (response *CreateYouhuiForOrderResponse, err error) {
	response = CreateCreateYouhuiForOrderResponse()
	err = client.DoAction(request, response)
	return
}

// CreateYouhuiForOrderWithChan invokes the rds.CreateYouhuiForOrder API asynchronously
func (client *Client) CreateYouhuiForOrderWithChan(request *CreateYouhuiForOrderRequest) (<-chan *CreateYouhuiForOrderResponse, <-chan error) {
	responseChan := make(chan *CreateYouhuiForOrderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateYouhuiForOrder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateYouhuiForOrderWithCallback invokes the rds.CreateYouhuiForOrder API asynchronously
func (client *Client) CreateYouhuiForOrderWithCallback(request *CreateYouhuiForOrderRequest, callback func(response *CreateYouhuiForOrderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateYouhuiForOrderResponse
		var err error
		defer close(result)
		response, err = client.CreateYouhuiForOrder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateYouhuiForOrderRequest is the request struct for api CreateYouhuiForOrder
type CreateYouhuiForOrderRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              string           `position:"Query" name:"OwnerId"`
	PromotionId          requests.Integer `position:"Query" name:"PromotionId"`
	ActivityId           requests.Integer `position:"Query" name:"ActivityId"`
}

// CreateYouhuiForOrderResponse is the response struct for api CreateYouhuiForOrder
type CreateYouhuiForOrderResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	YouhuiId  string `json:"YouhuiId" xml:"YouhuiId"`
}

// CreateCreateYouhuiForOrderRequest creates a request to invoke CreateYouhuiForOrder API
func CreateCreateYouhuiForOrderRequest() (request *CreateYouhuiForOrderRequest) {
	request = &CreateYouhuiForOrderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "CreateYouhuiForOrder", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateYouhuiForOrderResponse creates a response to parse from CreateYouhuiForOrder response
func CreateCreateYouhuiForOrderResponse() (response *CreateYouhuiForOrderResponse) {
	response = &CreateYouhuiForOrderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
