package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyGlobalSecurityIPGroupRelation invokes the r_kvstore.ModifyGlobalSecurityIPGroupRelation API synchronously
func (client *Client) ModifyGlobalSecurityIPGroupRelation(request *ModifyGlobalSecurityIPGroupRelationRequest) (response *ModifyGlobalSecurityIPGroupRelationResponse, err error) {
	response = CreateModifyGlobalSecurityIPGroupRelationResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyGlobalSecurityIPGroupRelationWithChan invokes the r_kvstore.ModifyGlobalSecurityIPGroupRelation API asynchronously
func (client *Client) ModifyGlobalSecurityIPGroupRelationWithChan(request *ModifyGlobalSecurityIPGroupRelationRequest) (<-chan *ModifyGlobalSecurityIPGroupRelationResponse, <-chan error) {
	responseChan := make(chan *ModifyGlobalSecurityIPGroupRelationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyGlobalSecurityIPGroupRelation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyGlobalSecurityIPGroupRelationWithCallback invokes the r_kvstore.ModifyGlobalSecurityIPGroupRelation API asynchronously
func (client *Client) ModifyGlobalSecurityIPGroupRelationWithCallback(request *ModifyGlobalSecurityIPGroupRelationRequest, callback func(response *ModifyGlobalSecurityIPGroupRelationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyGlobalSecurityIPGroupRelationResponse
		var err error
		defer close(result)
		response, err = client.ModifyGlobalSecurityIPGroupRelation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyGlobalSecurityIPGroupRelationRequest is the request struct for api ModifyGlobalSecurityIPGroupRelation
type ModifyGlobalSecurityIPGroupRelationRequest struct {
	*requests.RpcRequest
	ResourceOwnerId       requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceGroupId       string           `position:"Query" name:"ResourceGroupId"`
	GlobalSecurityGroupId string           `position:"Query" name:"GlobalSecurityGroupId"`
	SecurityToken         string           `position:"Query" name:"SecurityToken"`
	ResourceOwnerAccount  string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId           string           `position:"Query" name:"DBClusterId"`
	OwnerAccount          string           `position:"Query" name:"OwnerAccount"`
	OwnerId               requests.Integer `position:"Query" name:"OwnerId"`
}

// ModifyGlobalSecurityIPGroupRelationResponse is the response struct for api ModifyGlobalSecurityIPGroupRelation
type ModifyGlobalSecurityIPGroupRelationResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyGlobalSecurityIPGroupRelationRequest creates a request to invoke ModifyGlobalSecurityIPGroupRelation API
func CreateModifyGlobalSecurityIPGroupRelationRequest() (request *ModifyGlobalSecurityIPGroupRelationRequest) {
	request = &ModifyGlobalSecurityIPGroupRelationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "ModifyGlobalSecurityIPGroupRelation", "redisa", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyGlobalSecurityIPGroupRelationResponse creates a response to parse from ModifyGlobalSecurityIPGroupRelation response
func CreateModifyGlobalSecurityIPGroupRelationResponse() (response *ModifyGlobalSecurityIPGroupRelationResponse) {
	response = &ModifyGlobalSecurityIPGroupRelationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
