package quotas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetQuotaApplicationApproval invokes the quotas.GetQuotaApplicationApproval API synchronously
func (client *Client) GetQuotaApplicationApproval(request *GetQuotaApplicationApprovalRequest) (response *GetQuotaApplicationApprovalResponse, err error) {
	response = CreateGetQuotaApplicationApprovalResponse()
	err = client.DoAction(request, response)
	return
}

// GetQuotaApplicationApprovalWithChan invokes the quotas.GetQuotaApplicationApproval API asynchronously
func (client *Client) GetQuotaApplicationApprovalWithChan(request *GetQuotaApplicationApprovalRequest) (<-chan *GetQuotaApplicationApprovalResponse, <-chan error) {
	responseChan := make(chan *GetQuotaApplicationApprovalResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetQuotaApplicationApproval(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetQuotaApplicationApprovalWithCallback invokes the quotas.GetQuotaApplicationApproval API asynchronously
func (client *Client) GetQuotaApplicationApprovalWithCallback(request *GetQuotaApplicationApprovalRequest, callback func(response *GetQuotaApplicationApprovalResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetQuotaApplicationApprovalResponse
		var err error
		defer close(result)
		response, err = client.GetQuotaApplicationApproval(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetQuotaApplicationApprovalRequest is the request struct for api GetQuotaApplicationApproval
type GetQuotaApplicationApprovalRequest struct {
	*requests.RpcRequest
	OriginalContext string `position:"Body" name:"OriginalContext"`
	ApplicationId   string `position:"Body" name:"ApplicationId"`
}

// GetQuotaApplicationApprovalResponse is the response struct for api GetQuotaApplicationApproval
type GetQuotaApplicationApprovalResponse struct {
	*responses.BaseResponse
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	DynamicCode    string   `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string   `json:"DynamicMessage" xml:"DynamicMessage"`
	ErrorMsg       string   `json:"ErrorMsg" xml:"ErrorMsg"`
	ErrorCode      string   `json:"ErrorCode" xml:"ErrorCode"`
	Success        bool     `json:"Success" xml:"Success"`
	AllowRetry     bool     `json:"AllowRetry" xml:"AllowRetry"`
	ErrorArgs      []string `json:"ErrorArgs" xml:"ErrorArgs"`
	Module         Module   `json:"Module" xml:"Module"`
}

// CreateGetQuotaApplicationApprovalRequest creates a request to invoke GetQuotaApplicationApproval API
func CreateGetQuotaApplicationApprovalRequest() (request *GetQuotaApplicationApprovalRequest) {
	request = &GetQuotaApplicationApprovalRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quotas", "2020-05-10", "GetQuotaApplicationApproval", "quotas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetQuotaApplicationApprovalResponse creates a response to parse from GetQuotaApplicationApproval response
func CreateGetQuotaApplicationApprovalResponse() (response *GetQuotaApplicationApprovalResponse) {
	response = &GetQuotaApplicationApprovalResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
