package pts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopTestingJMeterScene invokes the pts.StopTestingJMeterScene API synchronously
func (client *Client) StopTestingJMeterScene(request *StopTestingJMeterSceneRequest) (response *StopTestingJMeterSceneResponse, err error) {
	response = CreateStopTestingJMeterSceneResponse()
	err = client.DoAction(request, response)
	return
}

// StopTestingJMeterSceneWithChan invokes the pts.StopTestingJMeterScene API asynchronously
func (client *Client) StopTestingJMeterSceneWithChan(request *StopTestingJMeterSceneRequest) (<-chan *StopTestingJMeterSceneResponse, <-chan error) {
	responseChan := make(chan *StopTestingJMeterSceneResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopTestingJMeterScene(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopTestingJMeterSceneWithCallback invokes the pts.StopTestingJMeterScene API asynchronously
func (client *Client) StopTestingJMeterSceneWithCallback(request *StopTestingJMeterSceneRequest, callback func(response *StopTestingJMeterSceneResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopTestingJMeterSceneResponse
		var err error
		defer close(result)
		response, err = client.StopTestingJMeterScene(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopTestingJMeterSceneRequest is the request struct for api StopTestingJMeterScene
type StopTestingJMeterSceneRequest struct {
	*requests.RpcRequest
	SceneId string `position:"Query" name:"SceneId"`
}

// StopTestingJMeterSceneResponse is the response struct for api StopTestingJMeterScene
type StopTestingJMeterSceneResponse struct {
	*responses.BaseResponse
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateStopTestingJMeterSceneRequest creates a request to invoke StopTestingJMeterScene API
func CreateStopTestingJMeterSceneRequest() (request *StopTestingJMeterSceneRequest) {
	request = &StopTestingJMeterSceneRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("PTS", "2020-10-20", "StopTestingJMeterScene", "", "")
	request.Method = requests.POST
	return
}

// CreateStopTestingJMeterSceneResponse creates a response to parse from StopTestingJMeterScene response
func CreateStopTestingJMeterSceneResponse() (response *StopTestingJMeterSceneResponse) {
	response = &StopTestingJMeterSceneResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
