package privatelink

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableVpcEndpointZoneConnection invokes the privatelink.EnableVpcEndpointZoneConnection API synchronously
func (client *Client) EnableVpcEndpointZoneConnection(request *EnableVpcEndpointZoneConnectionRequest) (response *EnableVpcEndpointZoneConnectionResponse, err error) {
	response = CreateEnableVpcEndpointZoneConnectionResponse()
	err = client.DoAction(request, response)
	return
}

// EnableVpcEndpointZoneConnectionWithChan invokes the privatelink.EnableVpcEndpointZoneConnection API asynchronously
func (client *Client) EnableVpcEndpointZoneConnectionWithChan(request *EnableVpcEndpointZoneConnectionRequest) (<-chan *EnableVpcEndpointZoneConnectionResponse, <-chan error) {
	responseChan := make(chan *EnableVpcEndpointZoneConnectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableVpcEndpointZoneConnection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableVpcEndpointZoneConnectionWithCallback invokes the privatelink.EnableVpcEndpointZoneConnection API asynchronously
func (client *Client) EnableVpcEndpointZoneConnectionWithCallback(request *EnableVpcEndpointZoneConnectionRequest, callback func(response *EnableVpcEndpointZoneConnectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableVpcEndpointZoneConnectionResponse
		var err error
		defer close(result)
		response, err = client.EnableVpcEndpointZoneConnection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableVpcEndpointZoneConnectionRequest is the request struct for api EnableVpcEndpointZoneConnection
type EnableVpcEndpointZoneConnectionRequest struct {
	*requests.RpcRequest
	ClientToken string           `position:"Query" name:"ClientToken"`
	EndpointId  string           `position:"Query" name:"EndpointId"`
	DryRun      requests.Boolean `position:"Query" name:"DryRun"`
	ZoneId      string           `position:"Query" name:"ZoneId"`
	ServiceId   string           `position:"Query" name:"ServiceId"`
}

// EnableVpcEndpointZoneConnectionResponse is the response struct for api EnableVpcEndpointZoneConnection
type EnableVpcEndpointZoneConnectionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateEnableVpcEndpointZoneConnectionRequest creates a request to invoke EnableVpcEndpointZoneConnection API
func CreateEnableVpcEndpointZoneConnectionRequest() (request *EnableVpcEndpointZoneConnectionRequest) {
	request = &EnableVpcEndpointZoneConnectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Privatelink", "2020-04-15", "EnableVpcEndpointZoneConnection", "privatelink", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEnableVpcEndpointZoneConnectionResponse creates a response to parse from EnableVpcEndpointZoneConnection response
func CreateEnableVpcEndpointZoneConnectionResponse() (response *EnableVpcEndpointZoneConnectionResponse) {
	response = &EnableVpcEndpointZoneConnectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
