package polardbx

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateBackupPolicy invokes the polardbx.UpdateBackupPolicy API synchronously
func (client *Client) UpdateBackupPolicy(request *UpdateBackupPolicyRequest) (response *UpdateBackupPolicyResponse, err error) {
	response = CreateUpdateBackupPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateBackupPolicyWithChan invokes the polardbx.UpdateBackupPolicy API asynchronously
func (client *Client) UpdateBackupPolicyWithChan(request *UpdateBackupPolicyRequest) (<-chan *UpdateBackupPolicyResponse, <-chan error) {
	responseChan := make(chan *UpdateBackupPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateBackupPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateBackupPolicyWithCallback invokes the polardbx.UpdateBackupPolicy API asynchronously
func (client *Client) UpdateBackupPolicyWithCallback(request *UpdateBackupPolicyRequest, callback func(response *UpdateBackupPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateBackupPolicyResponse
		var err error
		defer close(result)
		response, err = client.UpdateBackupPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateBackupPolicyRequest is the request struct for api UpdateBackupPolicy
type UpdateBackupPolicyRequest struct {
	*requests.RpcRequest
	DBInstanceName                 string           `position:"Query" name:"DBInstanceName"`
	CrossRegionDataBackupRetention requests.Integer `position:"Query" name:"CrossRegionDataBackupRetention"`
	ForceCleanOnHighSpaceUsage     requests.Integer `position:"Query" name:"ForceCleanOnHighSpaceUsage"`
	BackupPlanBegin                string           `position:"Query" name:"BackupPlanBegin"`
	RemoveLogRetention             requests.Integer `position:"Query" name:"RemoveLogRetention"`
	ColdDataBackupRetention        requests.Integer `position:"Query" name:"ColdDataBackupRetention"`
	LocalLogRetentionNumber        requests.Integer `position:"Query" name:"LocalLogRetentionNumber"`
	BackupType                     string           `position:"Query" name:"BackupType"`
	IsEnabled                      requests.Integer `position:"Query" name:"IsEnabled"`
	ColdDataBackupInterval         requests.Integer `position:"Query" name:"ColdDataBackupInterval"`
	BackupWay                      string           `position:"Query" name:"BackupWay"`
	DestCrossRegion                string           `position:"Query" name:"DestCrossRegion"`
	BackupSetRetention             requests.Integer `position:"Query" name:"BackupSetRetention"`
	IsCrossRegionDataBackupEnabled requests.Boolean `position:"Query" name:"IsCrossRegionDataBackupEnabled"`
	CrossRegionLogBackupRetention  requests.Integer `position:"Query" name:"CrossRegionLogBackupRetention"`
	BackupPeriod                   string           `position:"Query" name:"BackupPeriod"`
	IsCrossRegionLogBackupEnabled  requests.Boolean `position:"Query" name:"IsCrossRegionLogBackupEnabled"`
	LocalLogRetention              requests.Integer `position:"Query" name:"LocalLogRetention"`
	LogLocalRetentionSpace         requests.Integer `position:"Query" name:"LogLocalRetentionSpace"`
}

// UpdateBackupPolicyResponse is the response struct for api UpdateBackupPolicy
type UpdateBackupPolicyResponse struct {
	*responses.BaseResponse
	Message   string    `json:"Message" xml:"Message"`
	RequestId string    `json:"RequestId" xml:"RequestId"`
	Success   bool      `json:"Success" xml:"Success"`
	Data      []Account `json:"Data" xml:"Data"`
}

// CreateUpdateBackupPolicyRequest creates a request to invoke UpdateBackupPolicy API
func CreateUpdateBackupPolicyRequest() (request *UpdateBackupPolicyRequest) {
	request = &UpdateBackupPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardbx", "2020-02-02", "UpdateBackupPolicy", "polardbx", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateBackupPolicyResponse creates a response to parse from UpdateBackupPolicy response
func CreateUpdateBackupPolicyResponse() (response *UpdateBackupPolicyResponse) {
	response = &UpdateBackupPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
