package polardbx

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReleaseColdDataVolume invokes the polardbx.ReleaseColdDataVolume API synchronously
func (client *Client) ReleaseColdDataVolume(request *ReleaseColdDataVolumeRequest) (response *ReleaseColdDataVolumeResponse, err error) {
	response = CreateReleaseColdDataVolumeResponse()
	err = client.DoAction(request, response)
	return
}

// ReleaseColdDataVolumeWithChan invokes the polardbx.ReleaseColdDataVolume API asynchronously
func (client *Client) ReleaseColdDataVolumeWithChan(request *ReleaseColdDataVolumeRequest) (<-chan *ReleaseColdDataVolumeResponse, <-chan error) {
	responseChan := make(chan *ReleaseColdDataVolumeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReleaseColdDataVolume(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReleaseColdDataVolumeWithCallback invokes the polardbx.ReleaseColdDataVolume API asynchronously
func (client *Client) ReleaseColdDataVolumeWithCallback(request *ReleaseColdDataVolumeRequest, callback func(response *ReleaseColdDataVolumeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReleaseColdDataVolumeResponse
		var err error
		defer close(result)
		response, err = client.ReleaseColdDataVolume(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReleaseColdDataVolumeRequest is the request struct for api ReleaseColdDataVolume
type ReleaseColdDataVolumeRequest struct {
	*requests.RpcRequest
	DBInstanceName string `position:"Query" name:"DBInstanceName"`
}

// ReleaseColdDataVolumeResponse is the response struct for api ReleaseColdDataVolume
type ReleaseColdDataVolumeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateReleaseColdDataVolumeRequest creates a request to invoke ReleaseColdDataVolume API
func CreateReleaseColdDataVolumeRequest() (request *ReleaseColdDataVolumeRequest) {
	request = &ReleaseColdDataVolumeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardbx", "2020-02-02", "ReleaseColdDataVolume", "polardbx", "openAPI")
	request.Method = requests.POST
	return
}

// CreateReleaseColdDataVolumeResponse creates a response to parse from ReleaseColdDataVolume response
func CreateReleaseColdDataVolumeResponse() (response *ReleaseColdDataVolumeResponse) {
	response = &ReleaseColdDataVolumeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
