package polardbx

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableRightsSeparation invokes the polardbx.DisableRightsSeparation API synchronously
func (client *Client) DisableRightsSeparation(request *DisableRightsSeparationRequest) (response *DisableRightsSeparationResponse, err error) {
	response = CreateDisableRightsSeparationResponse()
	err = client.DoAction(request, response)
	return
}

// DisableRightsSeparationWithChan invokes the polardbx.DisableRightsSeparation API asynchronously
func (client *Client) DisableRightsSeparationWithChan(request *DisableRightsSeparationRequest) (<-chan *DisableRightsSeparationResponse, <-chan error) {
	responseChan := make(chan *DisableRightsSeparationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableRightsSeparation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableRightsSeparationWithCallback invokes the polardbx.DisableRightsSeparation API asynchronously
func (client *Client) DisableRightsSeparationWithCallback(request *DisableRightsSeparationRequest, callback func(response *DisableRightsSeparationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableRightsSeparationResponse
		var err error
		defer close(result)
		response, err = client.DisableRightsSeparation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableRightsSeparationRequest is the request struct for api DisableRightsSeparation
type DisableRightsSeparationRequest struct {
	*requests.RpcRequest
	DBInstanceName     string `position:"Query" name:"DBInstanceName"`
	DbaAccountPassword string `position:"Query" name:"DbaAccountPassword"`
	DbaAccountName     string `position:"Query" name:"DbaAccountName"`
}

// DisableRightsSeparationResponse is the response struct for api DisableRightsSeparation
type DisableRightsSeparationResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateDisableRightsSeparationRequest creates a request to invoke DisableRightsSeparation API
func CreateDisableRightsSeparationRequest() (request *DisableRightsSeparationRequest) {
	request = &DisableRightsSeparationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardbx", "2020-02-02", "DisableRightsSeparation", "polardbx", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDisableRightsSeparationResponse creates a response to parse from DisableRightsSeparation response
func CreateDisableRightsSeparationResponse() (response *DisableRightsSeparationResponse) {
	response = &DisableRightsSeparationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
