package petadata

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInstanceInfo invokes the petadata.DescribeInstanceInfo API synchronously
// api document: https://help.aliyun.com/api/petadata/describeinstanceinfo.html
func (client *Client) DescribeInstanceInfo(request *DescribeInstanceInfoRequest) (response *DescribeInstanceInfoResponse, err error) {
	response = CreateDescribeInstanceInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInstanceInfoWithChan invokes the petadata.DescribeInstanceInfo API asynchronously
// api document: https://help.aliyun.com/api/petadata/describeinstanceinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeInstanceInfoWithChan(request *DescribeInstanceInfoRequest) (<-chan *DescribeInstanceInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeInstanceInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInstanceInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInstanceInfoWithCallback invokes the petadata.DescribeInstanceInfo API asynchronously
// api document: https://help.aliyun.com/api/petadata/describeinstanceinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeInstanceInfoWithCallback(request *DescribeInstanceInfoRequest, callback func(response *DescribeInstanceInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInstanceInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeInstanceInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInstanceInfoRequest is the request struct for api DescribeInstanceInfo
type DescribeInstanceInfoRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeInstanceInfoResponse is the response struct for api DescribeInstanceInfo
type DescribeInstanceInfoResponse struct {
	*responses.BaseResponse
	RequestId        string                          `json:"RequestId" xml:"RequestId"`
	InstanceId       string                          `json:"InstanceId" xml:"InstanceId"`
	InstanceName     string                          `json:"InstanceName" xml:"InstanceName"`
	RegionId         string                          `json:"RegionId" xml:"RegionId"`
	ZoneId           string                          `json:"ZoneId" xml:"ZoneId"`
	InstanceStatus   string                          `json:"InstanceStatus" xml:"InstanceStatus"`
	NetworkInfoItems NetworkInfoItems                `json:"NetworkInfoItems" xml:"NetworkInfoItems"`
	Databases        DatabasesInDescribeInstanceInfo `json:"Databases" xml:"Databases"`
}

// CreateDescribeInstanceInfoRequest creates a request to invoke DescribeInstanceInfo API
func CreateDescribeInstanceInfoRequest() (request *DescribeInstanceInfoRequest) {
	request = &DescribeInstanceInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("PetaData", "2016-01-01", "DescribeInstanceInfo", "petadata", "openAPI")
	return
}

// CreateDescribeInstanceInfoResponse creates a response to parse from DescribeInstanceInfo response
func CreateDescribeInstanceInfoResponse() (response *DescribeInstanceInfoResponse) {
	response = &DescribeInstanceInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
