package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SplitTrafficControlTarget invokes the pairecservice.SplitTrafficControlTarget API synchronously
func (client *Client) SplitTrafficControlTarget(request *SplitTrafficControlTargetRequest) (response *SplitTrafficControlTargetResponse, err error) {
	response = CreateSplitTrafficControlTargetResponse()
	err = client.DoAction(request, response)
	return
}

// SplitTrafficControlTargetWithChan invokes the pairecservice.SplitTrafficControlTarget API asynchronously
func (client *Client) SplitTrafficControlTargetWithChan(request *SplitTrafficControlTargetRequest) (<-chan *SplitTrafficControlTargetResponse, <-chan error) {
	responseChan := make(chan *SplitTrafficControlTargetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SplitTrafficControlTarget(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SplitTrafficControlTargetWithCallback invokes the pairecservice.SplitTrafficControlTarget API asynchronously
func (client *Client) SplitTrafficControlTargetWithCallback(request *SplitTrafficControlTargetRequest, callback func(response *SplitTrafficControlTargetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SplitTrafficControlTargetResponse
		var err error
		defer close(result)
		response, err = client.SplitTrafficControlTarget(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SplitTrafficControlTargetRequest is the request struct for api SplitTrafficControlTarget
type SplitTrafficControlTargetRequest struct {
	*requests.RoaRequest
	TrafficControlTargetId string `position:"Path" name:"TrafficControlTargetId"`
	Body                   string `position:"Body" name:"body"`
}

// SplitTrafficControlTargetResponse is the response struct for api SplitTrafficControlTarget
type SplitTrafficControlTargetResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSplitTrafficControlTargetRequest creates a request to invoke SplitTrafficControlTarget API
func CreateSplitTrafficControlTargetRequest() (request *SplitTrafficControlTargetRequest) {
	request = &SplitTrafficControlTargetRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "SplitTrafficControlTarget", "/api/v1/trafficcontroltargets/[TrafficControlTargetId]/action/split", "", "")
	request.Method = requests.POST
	return
}

// CreateSplitTrafficControlTargetResponse creates a response to parse from SplitTrafficControlTarget response
func CreateSplitTrafficControlTargetResponse() (response *SplitTrafficControlTargetResponse) {
	response = &SplitTrafficControlTargetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
