package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCrowds invokes the pairecservice.ListCrowds API synchronously
func (client *Client) ListCrowds(request *ListCrowdsRequest) (response *ListCrowdsResponse, err error) {
	response = CreateListCrowdsResponse()
	err = client.DoAction(request, response)
	return
}

// ListCrowdsWithChan invokes the pairecservice.ListCrowds API asynchronously
func (client *Client) ListCrowdsWithChan(request *ListCrowdsRequest) (<-chan *ListCrowdsResponse, <-chan error) {
	responseChan := make(chan *ListCrowdsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCrowds(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListCrowdsWithCallback invokes the pairecservice.ListCrowds API asynchronously
func (client *Client) ListCrowdsWithCallback(request *ListCrowdsRequest, callback func(response *ListCrowdsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListCrowdsResponse
		var err error
		defer close(result)
		response, err = client.ListCrowds(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListCrowdsRequest is the request struct for api ListCrowds
type ListCrowdsRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Query" name:"InstanceId"`
}

// ListCrowdsResponse is the response struct for api ListCrowds
type ListCrowdsResponse struct {
	*responses.BaseResponse
	RequestId  string       `json:"RequestId" xml:"RequestId"`
	TotalCount int64        `json:"TotalCount" xml:"TotalCount"`
	Crowds     []CrowdsItem `json:"Crowds" xml:"Crowds"`
}

// CreateListCrowdsRequest creates a request to invoke ListCrowds API
func CreateListCrowdsRequest() (request *ListCrowdsRequest) {
	request = &ListCrowdsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "ListCrowds", "/api/v1/crowds", "", "")
	request.Method = requests.GET
	return
}

// CreateListCrowdsResponse creates a response to parse from ListCrowds response
func CreateListCrowdsResponse() (response *ListCrowdsResponse) {
	response = &ListCrowdsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
