package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CloneLaboratory invokes the pairecservice.CloneLaboratory API synchronously
func (client *Client) CloneLaboratory(request *CloneLaboratoryRequest) (response *CloneLaboratoryResponse, err error) {
	response = CreateCloneLaboratoryResponse()
	err = client.DoAction(request, response)
	return
}

// CloneLaboratoryWithChan invokes the pairecservice.CloneLaboratory API asynchronously
func (client *Client) CloneLaboratoryWithChan(request *CloneLaboratoryRequest) (<-chan *CloneLaboratoryResponse, <-chan error) {
	responseChan := make(chan *CloneLaboratoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CloneLaboratory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CloneLaboratoryWithCallback invokes the pairecservice.CloneLaboratory API asynchronously
func (client *Client) CloneLaboratoryWithCallback(request *CloneLaboratoryRequest, callback func(response *CloneLaboratoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CloneLaboratoryResponse
		var err error
		defer close(result)
		response, err = client.CloneLaboratory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CloneLaboratoryRequest is the request struct for api CloneLaboratory
type CloneLaboratoryRequest struct {
	*requests.RoaRequest
	LaboratoryId string `position:"Path" name:"LaboratoryId"`
	Body         string `position:"Body" name:"body"`
}

// CloneLaboratoryResponse is the response struct for api CloneLaboratory
type CloneLaboratoryResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	LaboratoryId string `json:"LaboratoryId" xml:"LaboratoryId"`
}

// CreateCloneLaboratoryRequest creates a request to invoke CloneLaboratory API
func CreateCloneLaboratoryRequest() (request *CloneLaboratoryRequest) {
	request = &CloneLaboratoryRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "CloneLaboratory", "/api/v1/laboratories/[LaboratoryId]/action/clone", "", "")
	request.Method = requests.POST
	return
}

// CreateCloneLaboratoryResponse creates a response to parse from CloneLaboratory response
func CreateCloneLaboratoryResponse() (response *CloneLaboratoryResponse) {
	response = &CloneLaboratoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
