package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeJobDataParsingTaskProgress invokes the outboundbot.DescribeJobDataParsingTaskProgress API synchronously
func (client *Client) DescribeJobDataParsingTaskProgress(request *DescribeJobDataParsingTaskProgressRequest) (response *DescribeJobDataParsingTaskProgressResponse, err error) {
	response = CreateDescribeJobDataParsingTaskProgressResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeJobDataParsingTaskProgressWithChan invokes the outboundbot.DescribeJobDataParsingTaskProgress API asynchronously
func (client *Client) DescribeJobDataParsingTaskProgressWithChan(request *DescribeJobDataParsingTaskProgressRequest) (<-chan *DescribeJobDataParsingTaskProgressResponse, <-chan error) {
	responseChan := make(chan *DescribeJobDataParsingTaskProgressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeJobDataParsingTaskProgress(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeJobDataParsingTaskProgressWithCallback invokes the outboundbot.DescribeJobDataParsingTaskProgress API asynchronously
func (client *Client) DescribeJobDataParsingTaskProgressWithCallback(request *DescribeJobDataParsingTaskProgressRequest, callback func(response *DescribeJobDataParsingTaskProgressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeJobDataParsingTaskProgressResponse
		var err error
		defer close(result)
		response, err = client.DescribeJobDataParsingTaskProgress(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeJobDataParsingTaskProgressRequest is the request struct for api DescribeJobDataParsingTaskProgress
type DescribeJobDataParsingTaskProgressRequest struct {
	*requests.RpcRequest
	InstanceId           string `position:"Query" name:"InstanceId"`
	JobDataParsingTaskId string `position:"Query" name:"JobDataParsingTaskId"`
}

// DescribeJobDataParsingTaskProgressResponse is the response struct for api DescribeJobDataParsingTaskProgress
type DescribeJobDataParsingTaskProgressResponse struct {
	*responses.BaseResponse
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string   `json:"Code" xml:"Code"`
	Message        string   `json:"Message" xml:"Message"`
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	Success        bool     `json:"Success" xml:"Success"`
	Progress       Progress `json:"Progress" xml:"Progress"`
}

// CreateDescribeJobDataParsingTaskProgressRequest creates a request to invoke DescribeJobDataParsingTaskProgress API
func CreateDescribeJobDataParsingTaskProgressRequest() (request *DescribeJobDataParsingTaskProgressRequest) {
	request = &DescribeJobDataParsingTaskProgressRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "DescribeJobDataParsingTaskProgress", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeJobDataParsingTaskProgressResponse creates a response to parse from DescribeJobDataParsingTaskProgress response
func CreateDescribeJobDataParsingTaskProgressResponse() (response *DescribeJobDataParsingTaskProgressResponse) {
	response = &DescribeJobDataParsingTaskProgressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
