package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSearchStrategy invokes the opensearch.GetSearchStrategy API synchronously
func (client *Client) GetSearchStrategy(request *GetSearchStrategyRequest) (response *GetSearchStrategyResponse, err error) {
	response = CreateGetSearchStrategyResponse()
	err = client.DoAction(request, response)
	return
}

// GetSearchStrategyWithChan invokes the opensearch.GetSearchStrategy API asynchronously
func (client *Client) GetSearchStrategyWithChan(request *GetSearchStrategyRequest) (<-chan *GetSearchStrategyResponse, <-chan error) {
	responseChan := make(chan *GetSearchStrategyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSearchStrategy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSearchStrategyWithCallback invokes the opensearch.GetSearchStrategy API asynchronously
func (client *Client) GetSearchStrategyWithCallback(request *GetSearchStrategyRequest, callback func(response *GetSearchStrategyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSearchStrategyResponse
		var err error
		defer close(result)
		response, err = client.GetSearchStrategy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSearchStrategyRequest is the request struct for api GetSearchStrategy
type GetSearchStrategyRequest struct {
	*requests.RoaRequest
	StrategyName     string `position:"Path" name:"strategyName"`
	AppId            string `position:"Path" name:"appId"`
	AppGroupIdentity string `position:"Path" name:"appGroupIdentity"`
}

// GetSearchStrategyResponse is the response struct for api GetSearchStrategy
type GetSearchStrategyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateGetSearchStrategyRequest creates a request to invoke GetSearchStrategy API
func CreateGetSearchStrategyRequest() (request *GetSearchStrategyRequest) {
	request = &GetSearchStrategyRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "GetSearchStrategy", "/v4/openapi/app-groups/[appGroupIdentity]/apps/[appId]/search-strategies/[strategyName]", "", "")
	request.Method = requests.GET
	return
}

// CreateGetSearchStrategyResponse creates a response to parse from GetSearchStrategy response
func CreateGetSearchStrategyResponse() (response *GetSearchStrategyResponse) {
	response = &GetSearchStrategyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
