package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyTagValueName invokes the oceanbasepro.ModifyTagValueName API synchronously
func (client *Client) ModifyTagValueName(request *ModifyTagValueNameRequest) (response *ModifyTagValueNameResponse, err error) {
	response = CreateModifyTagValueNameResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyTagValueNameWithChan invokes the oceanbasepro.ModifyTagValueName API asynchronously
func (client *Client) ModifyTagValueNameWithChan(request *ModifyTagValueNameRequest) (<-chan *ModifyTagValueNameResponse, <-chan error) {
	responseChan := make(chan *ModifyTagValueNameResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyTagValueName(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyTagValueNameWithCallback invokes the oceanbasepro.ModifyTagValueName API asynchronously
func (client *Client) ModifyTagValueNameWithCallback(request *ModifyTagValueNameRequest, callback func(response *ModifyTagValueNameResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyTagValueNameResponse
		var err error
		defer close(result)
		response, err = client.ModifyTagValueName(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyTagValueNameRequest is the request struct for api ModifyTagValueName
type ModifyTagValueNameRequest struct {
	*requests.RpcRequest
	NewValue string `position:"Body" name:"NewValue"`
	Value    string `position:"Body" name:"Value"`
	Key      string `position:"Body" name:"Key"`
}

// ModifyTagValueNameResponse is the response struct for api ModifyTagValueName
type ModifyTagValueNameResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyTagValueNameRequest creates a request to invoke ModifyTagValueName API
func CreateModifyTagValueNameRequest() (request *ModifyTagValueNameRequest) {
	request = &ModifyTagValueNameRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "ModifyTagValueName", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyTagValueNameResponse creates a response to parse from ModifyTagValueName response
func CreateModifyTagValueNameResponse() (response *ModifyTagValueNameResponse) {
	response = &ModifyTagValueNameResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
