package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteTenantSecurityIpGroup invokes the oceanbasepro.DeleteTenantSecurityIpGroup API synchronously
func (client *Client) DeleteTenantSecurityIpGroup(request *DeleteTenantSecurityIpGroupRequest) (response *DeleteTenantSecurityIpGroupResponse, err error) {
	response = CreateDeleteTenantSecurityIpGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteTenantSecurityIpGroupWithChan invokes the oceanbasepro.DeleteTenantSecurityIpGroup API asynchronously
func (client *Client) DeleteTenantSecurityIpGroupWithChan(request *DeleteTenantSecurityIpGroupRequest) (<-chan *DeleteTenantSecurityIpGroupResponse, <-chan error) {
	responseChan := make(chan *DeleteTenantSecurityIpGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteTenantSecurityIpGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteTenantSecurityIpGroupWithCallback invokes the oceanbasepro.DeleteTenantSecurityIpGroup API asynchronously
func (client *Client) DeleteTenantSecurityIpGroupWithCallback(request *DeleteTenantSecurityIpGroupRequest, callback func(response *DeleteTenantSecurityIpGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteTenantSecurityIpGroupResponse
		var err error
		defer close(result)
		response, err = client.DeleteTenantSecurityIpGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteTenantSecurityIpGroupRequest is the request struct for api DeleteTenantSecurityIpGroup
type DeleteTenantSecurityIpGroupRequest struct {
	*requests.RpcRequest
	SecurityIpGroupName string `position:"Body" name:"SecurityIpGroupName"`
	InstanceId          string `position:"Body" name:"InstanceId"`
	TenantId            string `position:"Body" name:"TenantId"`
}

// DeleteTenantSecurityIpGroupResponse is the response struct for api DeleteTenantSecurityIpGroup
type DeleteTenantSecurityIpGroupResponse struct {
	*responses.BaseResponse
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	SecurityIpGroup SecurityIpGroup `json:"SecurityIpGroup" xml:"SecurityIpGroup"`
}

// CreateDeleteTenantSecurityIpGroupRequest creates a request to invoke DeleteTenantSecurityIpGroup API
func CreateDeleteTenantSecurityIpGroupRequest() (request *DeleteTenantSecurityIpGroupRequest) {
	request = &DeleteTenantSecurityIpGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DeleteTenantSecurityIpGroup", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteTenantSecurityIpGroupResponse creates a response to parse from DeleteTenantSecurityIpGroup response
func CreateDeleteTenantSecurityIpGroupResponse() (response *DeleteTenantSecurityIpGroupResponse) {
	response = &DeleteTenantSecurityIpGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
