package oam

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddGroupTagMiddle invokes the oam.AddGroupTagMiddle API synchronously
// api document: https://help.aliyun.com/api/oam/addgrouptagmiddle.html
func (client *Client) AddGroupTagMiddle(request *AddGroupTagMiddleRequest) (response *AddGroupTagMiddleResponse, err error) {
	response = CreateAddGroupTagMiddleResponse()
	err = client.DoAction(request, response)
	return
}

// AddGroupTagMiddleWithChan invokes the oam.AddGroupTagMiddle API asynchronously
// api document: https://help.aliyun.com/api/oam/addgrouptagmiddle.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddGroupTagMiddleWithChan(request *AddGroupTagMiddleRequest) (<-chan *AddGroupTagMiddleResponse, <-chan error) {
	responseChan := make(chan *AddGroupTagMiddleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddGroupTagMiddle(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddGroupTagMiddleWithCallback invokes the oam.AddGroupTagMiddle API asynchronously
// api document: https://help.aliyun.com/api/oam/addgrouptagmiddle.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddGroupTagMiddleWithCallback(request *AddGroupTagMiddleRequest, callback func(response *AddGroupTagMiddleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddGroupTagMiddleResponse
		var err error
		defer close(result)
		response, err = client.AddGroupTagMiddle(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddGroupTagMiddleRequest is the request struct for api AddGroupTagMiddle
type AddGroupTagMiddleRequest struct {
	*requests.RpcRequest
	TagId       *[]string `position:"Query" name:"TagId"  type:"Repeated"`
	ClientToken string    `position:"Query" name:"ClientToken"`
	GroupTagId  string    `position:"Query" name:"GroupTagId"`
}

// AddGroupTagMiddleResponse is the response struct for api AddGroupTagMiddle
type AddGroupTagMiddleResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddGroupTagMiddleRequest creates a request to invoke AddGroupTagMiddle API
func CreateAddGroupTagMiddleRequest() (request *AddGroupTagMiddleRequest) {
	request = &AddGroupTagMiddleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Oam", "2017-01-01", "AddGroupTagMiddle", "", "")
	request.Method = requests.POST
	return
}

// CreateAddGroupTagMiddleResponse creates a response to parse from AddGroupTagMiddle response
func CreateAddGroupTagMiddleResponse() (response *AddGroupTagMiddleResponse) {
	response = &AddGroupTagMiddleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
