package oam

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddGroupTag invokes the oam.AddGroupTag API synchronously
// api document: https://help.aliyun.com/api/oam/addgrouptag.html
func (client *Client) AddGroupTag(request *AddGroupTagRequest) (response *AddGroupTagResponse, err error) {
	response = CreateAddGroupTagResponse()
	err = client.DoAction(request, response)
	return
}

// AddGroupTagWithChan invokes the oam.AddGroupTag API asynchronously
// api document: https://help.aliyun.com/api/oam/addgrouptag.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddGroupTagWithChan(request *AddGroupTagRequest) (<-chan *AddGroupTagResponse, <-chan error) {
	responseChan := make(chan *AddGroupTagResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddGroupTag(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddGroupTagWithCallback invokes the oam.AddGroupTag API asynchronously
// api document: https://help.aliyun.com/api/oam/addgrouptag.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddGroupTagWithCallback(request *AddGroupTagRequest, callback func(response *AddGroupTagResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddGroupTagResponse
		var err error
		defer close(result)
		response, err = client.AddGroupTag(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddGroupTagRequest is the request struct for api AddGroupTag
type AddGroupTagRequest struct {
	*requests.RpcRequest
	ClientToken string `position:"Query" name:"ClientToken"`
	Name        string `position:"Query" name:"Name"`
	Description string `position:"Query" name:"Description"`
}

// AddGroupTagResponse is the response struct for api AddGroupTag
type AddGroupTagResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddGroupTagRequest creates a request to invoke AddGroupTag API
func CreateAddGroupTagRequest() (request *AddGroupTagRequest) {
	request = &AddGroupTagRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Oam", "2017-01-01", "AddGroupTag", "", "")
	request.Method = requests.POST
	return
}

// CreateAddGroupTagResponse creates a response to parse from AddGroupTag response
func CreateAddGroupTagResponse() (response *AddGroupTagResponse) {
	response = &AddGroupTagResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
