package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitTraceAbJob invokes the mts.SubmitTraceAbJob API synchronously
func (client *Client) SubmitTraceAbJob(request *SubmitTraceAbJobRequest) (response *SubmitTraceAbJobResponse, err error) {
	response = CreateSubmitTraceAbJobResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitTraceAbJobWithChan invokes the mts.SubmitTraceAbJob API asynchronously
func (client *Client) SubmitTraceAbJobWithChan(request *SubmitTraceAbJobRequest) (<-chan *SubmitTraceAbJobResponse, <-chan error) {
	responseChan := make(chan *SubmitTraceAbJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitTraceAbJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitTraceAbJobWithCallback invokes the mts.SubmitTraceAbJob API asynchronously
func (client *Client) SubmitTraceAbJobWithCallback(request *SubmitTraceAbJobRequest, callback func(response *SubmitTraceAbJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitTraceAbJobResponse
		var err error
		defer close(result)
		response, err = client.SubmitTraceAbJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitTraceAbJobRequest is the request struct for api SubmitTraceAbJob
type SubmitTraceAbJobRequest struct {
	*requests.RpcRequest
	StartTime      string           `position:"Query" name:"StartTime"`
	Output         string           `position:"Query" name:"Output"`
	UserData       string           `position:"Query" name:"UserData"`
	CipherBase64ed string           `position:"Query" name:"CipherBase64ed"`
	Level          requests.Integer `position:"Query" name:"Level"`
	Url            string           `position:"Query" name:"Url"`
	Input          string           `position:"Query" name:"Input"`
	TotalTime      string           `position:"Query" name:"TotalTime"`
	CallBack       string           `position:"Query" name:"CallBack"`
}

// SubmitTraceAbJobResponse is the response struct for api SubmitTraceAbJob
type SubmitTraceAbJobResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Message    string `json:"Message" xml:"Message"`
	StatusCode int64  `json:"StatusCode" xml:"StatusCode"`
	Data       Data   `json:"Data" xml:"Data"`
}

// CreateSubmitTraceAbJobRequest creates a request to invoke SubmitTraceAbJob API
func CreateSubmitTraceAbJobRequest() (request *SubmitTraceAbJobRequest) {
	request = &SubmitTraceAbJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "SubmitTraceAbJob", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSubmitTraceAbJobResponse creates a response to parse from SubmitTraceAbJob response
func CreateSubmitTraceAbJobResponse() (response *SubmitTraceAbJobResponse) {
	response = &SubmitTraceAbJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
