package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryTraceAbJob invokes the mts.QueryTraceAbJob API synchronously
func (client *Client) QueryTraceAbJob(request *QueryTraceAbJobRequest) (response *QueryTraceAbJobResponse, err error) {
	response = CreateQueryTraceAbJobResponse()
	err = client.DoAction(request, response)
	return
}

// QueryTraceAbJobWithChan invokes the mts.QueryTraceAbJob API asynchronously
func (client *Client) QueryTraceAbJobWithChan(request *QueryTraceAbJobRequest) (<-chan *QueryTraceAbJobResponse, <-chan error) {
	responseChan := make(chan *QueryTraceAbJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryTraceAbJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryTraceAbJobWithCallback invokes the mts.QueryTraceAbJob API asynchronously
func (client *Client) QueryTraceAbJobWithCallback(request *QueryTraceAbJobRequest, callback func(response *QueryTraceAbJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryTraceAbJobResponse
		var err error
		defer close(result)
		response, err = client.QueryTraceAbJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryTraceAbJobRequest is the request struct for api QueryTraceAbJob
type QueryTraceAbJobRequest struct {
	*requests.RpcRequest
	MediaId string `position:"Query" name:"MediaId"`
	JobId   string `position:"Query" name:"JobId"`
}

// QueryTraceAbJobResponse is the response struct for api QueryTraceAbJob
type QueryTraceAbJobResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	Message    string     `json:"Message" xml:"Message"`
	StatusCode int64      `json:"StatusCode" xml:"StatusCode"`
	Data       []DataItem `json:"Data" xml:"Data"`
}

// CreateQueryTraceAbJobRequest creates a request to invoke QueryTraceAbJob API
func CreateQueryTraceAbJobRequest() (request *QueryTraceAbJobRequest) {
	request = &QueryTraceAbJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "QueryTraceAbJob", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryTraceAbJobResponse creates a response to parse from QueryTraceAbJob response
func CreateQueryTraceAbJobResponse() (response *QueryTraceAbJobResponse) {
	response = &QueryTraceAbJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
