package mseap

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PullTask invokes the mseap.PullTask API synchronously
func (client *Client) PullTask(request *PullTaskRequest) (response *PullTaskResponse, err error) {
	response = CreatePullTaskResponse()
	err = client.DoAction(request, response)
	return
}

// PullTaskWithChan invokes the mseap.PullTask API asynchronously
func (client *Client) PullTaskWithChan(request *PullTaskRequest) (<-chan *PullTaskResponse, <-chan error) {
	responseChan := make(chan *PullTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PullTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PullTaskWithCallback invokes the mseap.PullTask API asynchronously
func (client *Client) PullTaskWithCallback(request *PullTaskRequest, callback func(response *PullTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PullTaskResponse
		var err error
		defer close(result)
		response, err = client.PullTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PullTaskRequest is the request struct for api PullTask
type PullTaskRequest struct {
	*requests.RpcRequest
	UserCallerParentId          requests.Integer `position:"Query" name:"UserCallerParentId"`
	ApiType                     string           `position:"Query" name:"ApiType"`
	UserMfaPresent              requests.Boolean `position:"Query" name:"UserMfaPresent"`
	UserKp                      string           `position:"Query" name:"UserKp"`
	Lang                        string           `position:"Query" name:"Lang"`
	UserCallerType              string           `position:"Query" name:"UserCallerType"`
	TaskType                    string           `position:"Query" name:"TaskType"`
	UserSecurityToken           string           `position:"Query" name:"UserSecurityToken"`
	UserAccessKeyId             string           `position:"Query" name:"UserAccessKeyId"`
	OrderId                     string           `position:"Query" name:"OrderId"`
	AliyunKp                    string           `position:"Query" name:"AliyunKp"`
	UserBid                     string           `position:"Query" name:"UserBid"`
	OriginalRequest             string           `position:"Query" name:"OriginalRequest"`
	PrincipalKey                string           `position:"Query" name:"PrincipalKey"`
	UserCallerSecurityTransport requests.Boolean `position:"Query" name:"UserCallerSecurityTransport"`
	BizCode                     string           `position:"Query" name:"BizCode"`
	UserClientIp                string           `position:"Query" name:"UserClientIp"`
	Bid                         string           `position:"Query" name:"Bid"`
}

// PullTaskResponse is the response struct for api PullTask
type PullTaskResponse struct {
	*responses.BaseResponse
	AllowRetry     bool   `json:"AllowRetry" xml:"AllowRetry"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ErrorMsg       string `json:"ErrorMsg" xml:"ErrorMsg"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	Success        bool   `json:"Success" xml:"Success"`
	AppName        string `json:"AppName" xml:"AppName"`
	Module         Module `json:"Module" xml:"Module"`
}

// CreatePullTaskRequest creates a request to invoke PullTask API
func CreatePullTaskRequest() (request *PullTaskRequest) {
	request = &PullTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mseap", "2021-01-18", "PullTask", "", "")
	request.Method = requests.POST
	return
}

// CreatePullTaskResponse creates a response to parse from PullTask response
func CreatePullTaskResponse() (response *PullTaskResponse) {
	response = &PullTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
