package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateNacosConfig invokes the mse.UpdateNacosConfig API synchronously
func (client *Client) UpdateNacosConfig(request *UpdateNacosConfigRequest) (response *UpdateNacosConfigResponse, err error) {
	response = CreateUpdateNacosConfigResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateNacosConfigWithChan invokes the mse.UpdateNacosConfig API asynchronously
func (client *Client) UpdateNacosConfigWithChan(request *UpdateNacosConfigRequest) (<-chan *UpdateNacosConfigResponse, <-chan error) {
	responseChan := make(chan *UpdateNacosConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateNacosConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateNacosConfigWithCallback invokes the mse.UpdateNacosConfig API asynchronously
func (client *Client) UpdateNacosConfigWithCallback(request *UpdateNacosConfigRequest, callback func(response *UpdateNacosConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateNacosConfigResponse
		var err error
		defer close(result)
		response, err = client.UpdateNacosConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateNacosConfigRequest is the request struct for api UpdateNacosConfig
type UpdateNacosConfigRequest struct {
	*requests.RpcRequest
	MseSessionId     string `position:"Query" name:"MseSessionId"`
	EncryptedDataKey string `position:"Query" name:"EncryptedDataKey"`
	Type             string `position:"Query" name:"Type"`
	AppName          string `position:"Query" name:"AppName"`
	NamespaceId      string `position:"Query" name:"NamespaceId"`
	Group            string `position:"Query" name:"Group"`
	Tags             string `position:"Query" name:"Tags"`
	BetaIps          string `position:"Query" name:"BetaIps"`
	InstanceId       string `position:"Query" name:"InstanceId"`
	Desc             string `position:"Query" name:"Desc"`
	Content          string `position:"Body" name:"Content"`
	DataId           string `position:"Query" name:"DataId"`
	AcceptLanguage   string `position:"Query" name:"AcceptLanguage"`
	Md5              string `position:"Query" name:"Md5"`
}

// UpdateNacosConfigResponse is the response struct for api UpdateNacosConfig
type UpdateNacosConfigResponse struct {
	*responses.BaseResponse
	HttpCode  string `json:"HttpCode" xml:"HttpCode"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateUpdateNacosConfigRequest creates a request to invoke UpdateNacosConfig API
func CreateUpdateNacosConfigRequest() (request *UpdateNacosConfigRequest) {
	request = &UpdateNacosConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "UpdateNacosConfig", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateNacosConfigResponse creates a response to parse from UpdateNacosConfig response
func CreateUpdateNacosConfigResponse() (response *UpdateNacosConfigResponse) {
	response = &UpdateNacosConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
