package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteMigrationTask invokes the mse.DeleteMigrationTask API synchronously
func (client *Client) DeleteMigrationTask(request *DeleteMigrationTaskRequest) (response *DeleteMigrationTaskResponse, err error) {
	response = CreateDeleteMigrationTaskResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteMigrationTaskWithChan invokes the mse.DeleteMigrationTask API asynchronously
func (client *Client) DeleteMigrationTaskWithChan(request *DeleteMigrationTaskRequest) (<-chan *DeleteMigrationTaskResponse, <-chan error) {
	responseChan := make(chan *DeleteMigrationTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteMigrationTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteMigrationTaskWithCallback invokes the mse.DeleteMigrationTask API asynchronously
func (client *Client) DeleteMigrationTaskWithCallback(request *DeleteMigrationTaskRequest, callback func(response *DeleteMigrationTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteMigrationTaskResponse
		var err error
		defer close(result)
		response, err = client.DeleteMigrationTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteMigrationTaskRequest is the request struct for api DeleteMigrationTask
type DeleteMigrationTaskRequest struct {
	*requests.RpcRequest
	MseSessionId   string `position:"Query" name:"MseSessionId"`
	RequestPars    string `position:"Query" name:"RequestPars"`
	Id             string `position:"Query" name:"Id"`
	AcceptLanguage string `position:"Query" name:"AcceptLanguage"`
}

// DeleteMigrationTaskResponse is the response struct for api DeleteMigrationTask
type DeleteMigrationTaskResponse struct {
	*responses.BaseResponse
	HttpCode  string `json:"HttpCode" xml:"HttpCode"`
	Data      bool   `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateDeleteMigrationTaskRequest creates a request to invoke DeleteMigrationTask API
func CreateDeleteMigrationTaskRequest() (request *DeleteMigrationTaskRequest) {
	request = &DeleteMigrationTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "DeleteMigrationTask", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteMigrationTaskResponse creates a response to parse from DeleteMigrationTask response
func CreateDeleteMigrationTaskResponse() (response *DeleteMigrationTaskResponse) {
	response = &DeleteMigrationTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
