package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PushSimple invokes the mpaas.PushSimple API synchronously
func (client *Client) PushSimple(request *PushSimpleRequest) (response *PushSimpleResponse, err error) {
	response = CreatePushSimpleResponse()
	err = client.DoAction(request, response)
	return
}

// PushSimpleWithChan invokes the mpaas.PushSimple API asynchronously
func (client *Client) PushSimpleWithChan(request *PushSimpleRequest) (<-chan *PushSimpleResponse, <-chan error) {
	responseChan := make(chan *PushSimpleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PushSimple(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PushSimpleWithCallback invokes the mpaas.PushSimple API asynchronously
func (client *Client) PushSimpleWithCallback(request *PushSimpleRequest, callback func(response *PushSimpleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PushSimpleResponse
		var err error
		defer close(result)
		response, err = client.PushSimple(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PushSimpleRequest is the request struct for api PushSimple
type PushSimpleRequest struct {
	*requests.RpcRequest
	SmsStrategy      requests.Integer `position:"Body" name:"SmsStrategy"`
	ImageUrls        string           `position:"Body" name:"ImageUrls"`
	TaskName         string           `position:"Body" name:"TaskName"`
	Title            string           `position:"Body" name:"Title"`
	Content          string           `position:"Body" name:"Content"`
	IconUrls         string           `position:"Body" name:"IconUrls"`
	PushAction       requests.Integer `position:"Body" name:"PushAction"`
	DeliveryType     requests.Integer `position:"Body" name:"DeliveryType"`
	SmsTemplateParam string           `position:"Body" name:"SmsTemplateParam"`
	NotifyType       string           `position:"Body" name:"NotifyType"`
	TargetMsgkey     string           `position:"Body" name:"TargetMsgkey"`
	PushStyle        requests.Integer `position:"Body" name:"PushStyle"`
	ExtendedParams   string           `position:"Body" name:"ExtendedParams"`
	Silent           requests.Integer `position:"Body" name:"Silent"`
	StrategyContent  string           `position:"Body" name:"StrategyContent"`
	Classification   string           `position:"Body" name:"Classification"`
	Uri              string           `position:"Body" name:"Uri"`
	ExpiredSeconds   requests.Integer `position:"Body" name:"ExpiredSeconds"`
	SmsTemplateCode  string           `position:"Body" name:"SmsTemplateCode"`
	AppId            string           `position:"Body" name:"AppId"`
	SmsSignName      string           `position:"Body" name:"SmsSignName"`
	StrategyType     requests.Integer `position:"Body" name:"StrategyType"`
	WorkspaceId      string           `position:"Body" name:"WorkspaceId"`
}

// PushSimpleResponse is the response struct for api PushSimple
type PushSimpleResponse struct {
	*responses.BaseResponse
	ResultMessage string     `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string     `json:"ResultCode" xml:"ResultCode"`
	RequestId     string     `json:"RequestId" xml:"RequestId"`
	PushResult    PushResult `json:"PushResult" xml:"PushResult"`
}

// CreatePushSimpleRequest creates a request to invoke PushSimple API
func CreatePushSimpleRequest() (request *PushSimpleRequest) {
	request = &PushSimpleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "PushSimple", "", "")
	request.Method = requests.POST
	return
}

// CreatePushSimpleResponse creates a response to parse from PushSimple response
func CreatePushSimpleResponse() (response *PushSimpleResponse) {
	response = &PushSimpleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
