package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMcubeMiniTasks invokes the mpaas.ListMcubeMiniTasks API synchronously
func (client *Client) ListMcubeMiniTasks(request *ListMcubeMiniTasksRequest) (response *ListMcubeMiniTasksResponse, err error) {
	response = CreateListMcubeMiniTasksResponse()
	err = client.DoAction(request, response)
	return
}

// ListMcubeMiniTasksWithChan invokes the mpaas.ListMcubeMiniTasks API asynchronously
func (client *Client) ListMcubeMiniTasksWithChan(request *ListMcubeMiniTasksRequest) (<-chan *ListMcubeMiniTasksResponse, <-chan error) {
	responseChan := make(chan *ListMcubeMiniTasksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMcubeMiniTasks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMcubeMiniTasksWithCallback invokes the mpaas.ListMcubeMiniTasks API asynchronously
func (client *Client) ListMcubeMiniTasksWithCallback(request *ListMcubeMiniTasksRequest, callback func(response *ListMcubeMiniTasksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMcubeMiniTasksResponse
		var err error
		defer close(result)
		response, err = client.ListMcubeMiniTasks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMcubeMiniTasksRequest is the request struct for api ListMcubeMiniTasks
type ListMcubeMiniTasksRequest struct {
	*requests.RpcRequest
	TenantId    string `position:"Body" name:"TenantId"`
	Id          string `position:"Body" name:"Id"`
	AppId       string `position:"Body" name:"AppId"`
	WorkspaceId string `position:"Body" name:"WorkspaceId"`
}

// ListMcubeMiniTasksResponse is the response struct for api ListMcubeMiniTasks
type ListMcubeMiniTasksResponse struct {
	*responses.BaseResponse
	ResultMessage      string             `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode         string             `json:"ResultCode" xml:"ResultCode"`
	RequestId          string             `json:"RequestId" xml:"RequestId"`
	ListMiniTaskResult ListMiniTaskResult `json:"ListMiniTaskResult" xml:"ListMiniTaskResult"`
}

// CreateListMcubeMiniTasksRequest creates a request to invoke ListMcubeMiniTasks API
func CreateListMcubeMiniTasksRequest() (request *ListMcubeMiniTasksRequest) {
	request = &ListMcubeMiniTasksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "ListMcubeMiniTasks", "", "")
	request.Method = requests.POST
	return
}

// CreateListMcubeMiniTasksResponse creates a response to parse from ListMcubeMiniTasks response
func CreateListMcubeMiniTasksResponse() (response *ListMcubeMiniTasksResponse) {
	response = &ListMcubeMiniTasksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
