package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetFileTokenForUploadToMsa invokes the mpaas.GetFileTokenForUploadToMsa API synchronously
func (client *Client) GetFileTokenForUploadToMsa(request *GetFileTokenForUploadToMsaRequest) (response *GetFileTokenForUploadToMsaResponse, err error) {
	response = CreateGetFileTokenForUploadToMsaResponse()
	err = client.DoAction(request, response)
	return
}

// GetFileTokenForUploadToMsaWithChan invokes the mpaas.GetFileTokenForUploadToMsa API asynchronously
func (client *Client) GetFileTokenForUploadToMsaWithChan(request *GetFileTokenForUploadToMsaRequest) (<-chan *GetFileTokenForUploadToMsaResponse, <-chan error) {
	responseChan := make(chan *GetFileTokenForUploadToMsaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetFileTokenForUploadToMsa(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetFileTokenForUploadToMsaWithCallback invokes the mpaas.GetFileTokenForUploadToMsa API asynchronously
func (client *Client) GetFileTokenForUploadToMsaWithCallback(request *GetFileTokenForUploadToMsaRequest, callback func(response *GetFileTokenForUploadToMsaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetFileTokenForUploadToMsaResponse
		var err error
		defer close(result)
		response, err = client.GetFileTokenForUploadToMsa(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetFileTokenForUploadToMsaRequest is the request struct for api GetFileTokenForUploadToMsa
type GetFileTokenForUploadToMsaRequest struct {
	*requests.RpcRequest
	OnexFlag    requests.Boolean `position:"Body" name:"OnexFlag"`
	TenantId    string           `position:"Body" name:"TenantId"`
	AppId       string           `position:"Body" name:"AppId"`
	WorkspaceId string           `position:"Body" name:"WorkspaceId"`
}

// GetFileTokenForUploadToMsaResponse is the response struct for api GetFileTokenForUploadToMsa
type GetFileTokenForUploadToMsaResponse struct {
	*responses.BaseResponse
	ResultMessage string        `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string        `json:"ResultCode" xml:"ResultCode"`
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	ResultContent ResultContent `json:"ResultContent" xml:"ResultContent"`
}

// CreateGetFileTokenForUploadToMsaRequest creates a request to invoke GetFileTokenForUploadToMsa API
func CreateGetFileTokenForUploadToMsaRequest() (request *GetFileTokenForUploadToMsaRequest) {
	request = &GetFileTokenForUploadToMsaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "GetFileTokenForUploadToMsa", "", "")
	request.Method = requests.POST
	return
}

// CreateGetFileTokenForUploadToMsaResponse creates a response to parse from GetFileTokenForUploadToMsa response
func CreateGetFileTokenForUploadToMsaResponse() (response *GetFileTokenForUploadToMsaResponse) {
	response = &GetFileTokenForUploadToMsaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
