package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateMcubeNebulaApp invokes the mpaas.CreateMcubeNebulaApp API synchronously
func (client *Client) CreateMcubeNebulaApp(request *CreateMcubeNebulaAppRequest) (response *CreateMcubeNebulaAppResponse, err error) {
	response = CreateCreateMcubeNebulaAppResponse()
	err = client.DoAction(request, response)
	return
}

// CreateMcubeNebulaAppWithChan invokes the mpaas.CreateMcubeNebulaApp API asynchronously
func (client *Client) CreateMcubeNebulaAppWithChan(request *CreateMcubeNebulaAppRequest) (<-chan *CreateMcubeNebulaAppResponse, <-chan error) {
	responseChan := make(chan *CreateMcubeNebulaAppResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateMcubeNebulaApp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateMcubeNebulaAppWithCallback invokes the mpaas.CreateMcubeNebulaApp API asynchronously
func (client *Client) CreateMcubeNebulaAppWithCallback(request *CreateMcubeNebulaAppRequest, callback func(response *CreateMcubeNebulaAppResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateMcubeNebulaAppResponse
		var err error
		defer close(result)
		response, err = client.CreateMcubeNebulaApp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateMcubeNebulaAppRequest is the request struct for api CreateMcubeNebulaApp
type CreateMcubeNebulaAppRequest struct {
	*requests.RpcRequest
	H5Name      string `position:"Body" name:"H5Name"`
	H5Id        string `position:"Body" name:"H5Id"`
	TenantId    string `position:"Body" name:"TenantId"`
	AppId       string `position:"Body" name:"AppId"`
	WorkspaceId string `position:"Body" name:"WorkspaceId"`
}

// CreateMcubeNebulaAppResponse is the response struct for api CreateMcubeNebulaApp
type CreateMcubeNebulaAppResponse struct {
	*responses.BaseResponse
	ResultMessage         string                `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode            string                `json:"ResultCode" xml:"ResultCode"`
	RequestId             string                `json:"RequestId" xml:"RequestId"`
	CreateNebulaAppResult CreateNebulaAppResult `json:"CreateNebulaAppResult" xml:"CreateNebulaAppResult"`
}

// CreateCreateMcubeNebulaAppRequest creates a request to invoke CreateMcubeNebulaApp API
func CreateCreateMcubeNebulaAppRequest() (request *CreateMcubeNebulaAppRequest) {
	request = &CreateMcubeNebulaAppRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "CreateMcubeNebulaApp", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateMcubeNebulaAppResponse creates a response to parse from CreateMcubeNebulaApp response
func CreateCreateMcubeNebulaAppResponse() (response *CreateMcubeNebulaAppResponse) {
	response = &CreateMcubeNebulaAppResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
