package mopen

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MoPenAddGroupMember invokes the mopen.MoPenAddGroupMember API synchronously
// api document: https://help.aliyun.com/api/mopen/mopenaddgroupmember.html
func (client *Client) MoPenAddGroupMember(request *MoPenAddGroupMemberRequest) (response *MoPenAddGroupMemberResponse, err error) {
	response = CreateMoPenAddGroupMemberResponse()
	err = client.DoAction(request, response)
	return
}

// MoPenAddGroupMemberWithChan invokes the mopen.MoPenAddGroupMember API asynchronously
// api document: https://help.aliyun.com/api/mopen/mopenaddgroupmember.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MoPenAddGroupMemberWithChan(request *MoPenAddGroupMemberRequest) (<-chan *MoPenAddGroupMemberResponse, <-chan error) {
	responseChan := make(chan *MoPenAddGroupMemberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MoPenAddGroupMember(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MoPenAddGroupMemberWithCallback invokes the mopen.MoPenAddGroupMember API asynchronously
// api document: https://help.aliyun.com/api/mopen/mopenaddgroupmember.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MoPenAddGroupMemberWithCallback(request *MoPenAddGroupMemberRequest, callback func(response *MoPenAddGroupMemberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MoPenAddGroupMemberResponse
		var err error
		defer close(result)
		response, err = client.MoPenAddGroupMember(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MoPenAddGroupMemberRequest is the request struct for api MoPenAddGroupMember
type MoPenAddGroupMemberRequest struct {
	*requests.RpcRequest
	GroupId    string `position:"Body" name:"GroupId"`
	DeviceName string `position:"Body" name:"DeviceName"`
}

// MoPenAddGroupMemberResponse is the response struct for api MoPenAddGroupMember
type MoPenAddGroupMemberResponse struct {
	*responses.BaseResponse
	Success     bool   `json:"Success" xml:"Success"`
	Code        string `json:"Code" xml:"Code"`
	Description string `json:"Description" xml:"Description"`
	Message     string `json:"Message" xml:"Message"`
}

// CreateMoPenAddGroupMemberRequest creates a request to invoke MoPenAddGroupMember API
func CreateMoPenAddGroupMemberRequest() (request *MoPenAddGroupMemberRequest) {
	request = &MoPenAddGroupMemberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("MoPen", "2018-02-11", "MoPenAddGroupMember", "mopen", "openAPI")
	return
}

// CreateMoPenAddGroupMemberResponse creates a response to parse from MoPenAddGroupMember response
func CreateMoPenAddGroupMemberResponse() (response *MoPenAddGroupMemberResponse) {
	response = &MoPenAddGroupMemberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
