package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListBaaSAntChain invokes the lto.ListBaaSAntChain API synchronously
func (client *Client) ListBaaSAntChain(request *ListBaaSAntChainRequest) (response *ListBaaSAntChainResponse, err error) {
	response = CreateListBaaSAntChainResponse()
	err = client.DoAction(request, response)
	return
}

// ListBaaSAntChainWithChan invokes the lto.ListBaaSAntChain API asynchronously
func (client *Client) ListBaaSAntChainWithChan(request *ListBaaSAntChainRequest) (<-chan *ListBaaSAntChainResponse, <-chan error) {
	responseChan := make(chan *ListBaaSAntChainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListBaaSAntChain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListBaaSAntChainWithCallback invokes the lto.ListBaaSAntChain API asynchronously
func (client *Client) ListBaaSAntChainWithCallback(request *ListBaaSAntChainRequest, callback func(response *ListBaaSAntChainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListBaaSAntChainResponse
		var err error
		defer close(result)
		response, err = client.ListBaaSAntChain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListBaaSAntChainRequest is the request struct for api ListBaaSAntChain
type ListBaaSAntChainRequest struct {
	*requests.RpcRequest
	BaaSAntChainConsortiumId string `position:"Query" name:"BaaSAntChainConsortiumId"`
}

// ListBaaSAntChainResponse is the response struct for api ListBaaSAntChain
type ListBaaSAntChainResponse struct {
	*responses.BaseResponse
	Code           string                  `json:"Code" xml:"Code"`
	HttpStatusCode int                     `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string                  `json:"Message" xml:"Message"`
	RequestId      string                  `json:"RequestId" xml:"RequestId"`
	Success        bool                    `json:"Success" xml:"Success"`
	Data           []BaaSAntChainChainInfo `json:"Data" xml:"Data"`
}

// CreateListBaaSAntChainRequest creates a request to invoke ListBaaSAntChain API
func CreateListBaaSAntChainRequest() (request *ListBaaSAntChainRequest) {
	request = &ListBaaSAntChainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "ListBaaSAntChain", "", "")
	request.Method = requests.POST
	return
}

// CreateListBaaSAntChainResponse creates a response to parse from ListBaaSAntChain response
func CreateListBaaSAntChainResponse() (response *ListBaaSAntChainResponse) {
	response = &ListBaaSAntChainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
