package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAllSystemContract invokes the lto.ListAllSystemContract API synchronously
func (client *Client) ListAllSystemContract(request *ListAllSystemContractRequest) (response *ListAllSystemContractResponse, err error) {
	response = CreateListAllSystemContractResponse()
	err = client.DoAction(request, response)
	return
}

// ListAllSystemContractWithChan invokes the lto.ListAllSystemContract API asynchronously
func (client *Client) ListAllSystemContractWithChan(request *ListAllSystemContractRequest) (<-chan *ListAllSystemContractResponse, <-chan error) {
	responseChan := make(chan *ListAllSystemContractResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAllSystemContract(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAllSystemContractWithCallback invokes the lto.ListAllSystemContract API asynchronously
func (client *Client) ListAllSystemContractWithCallback(request *ListAllSystemContractRequest, callback func(response *ListAllSystemContractResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAllSystemContractResponse
		var err error
		defer close(result)
		response, err = client.ListAllSystemContract(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAllSystemContractRequest is the request struct for api ListAllSystemContract
type ListAllSystemContractRequest struct {
	*requests.RpcRequest
	BlockChainType string `position:"Query" name:"BlockChainType"`
}

// ListAllSystemContractResponse is the response struct for api ListAllSystemContract
type ListAllSystemContractResponse struct {
	*responses.BaseResponse
	Code           string               `json:"Code" xml:"Code"`
	HttpStatusCode int                  `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string               `json:"Message" xml:"Message"`
	RequestId      string               `json:"RequestId" xml:"RequestId"`
	Success        bool                 `json:"Success" xml:"Success"`
	Data           []SystemContractInfo `json:"Data" xml:"Data"`
}

// CreateListAllSystemContractRequest creates a request to invoke ListAllSystemContract API
func CreateListAllSystemContractRequest() (request *ListAllSystemContractRequest) {
	request = &ListAllSystemContractRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "ListAllSystemContract", "", "")
	request.Method = requests.POST
	return
}

// CreateListAllSystemContractResponse creates a response to parse from ListAllSystemContract response
func CreateListAllSystemContractResponse() (response *ListAllSystemContractResponse) {
	response = &ListAllSystemContractResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
