package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableDevice invokes the lto.DisableDevice API synchronously
func (client *Client) DisableDevice(request *DisableDeviceRequest) (response *DisableDeviceResponse, err error) {
	response = CreateDisableDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// DisableDeviceWithChan invokes the lto.DisableDevice API asynchronously
func (client *Client) DisableDeviceWithChan(request *DisableDeviceRequest) (<-chan *DisableDeviceResponse, <-chan error) {
	responseChan := make(chan *DisableDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableDeviceWithCallback invokes the lto.DisableDevice API asynchronously
func (client *Client) DisableDeviceWithCallback(request *DisableDeviceRequest, callback func(response *DisableDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableDeviceResponse
		var err error
		defer close(result)
		response, err = client.DisableDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableDeviceRequest is the request struct for api DisableDevice
type DisableDeviceRequest struct {
	*requests.RpcRequest
	DeviceId string `position:"Query" name:"DeviceId"`
}

// DisableDeviceResponse is the response struct for api DisableDevice
type DisableDeviceResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateDisableDeviceRequest creates a request to invoke DisableDevice API
func CreateDisableDeviceRequest() (request *DisableDeviceRequest) {
	request = &DisableDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "DisableDevice", "", "")
	request.Method = requests.POST
	return
}

// CreateDisableDeviceResponse creates a response to parse from DisableDevice response
func CreateDisableDeviceResponse() (response *DisableDeviceResponse) {
	response = &DisableDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
