package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEdgeStatInfo invokes the lto.DescribeEdgeStatInfo API synchronously
func (client *Client) DescribeEdgeStatInfo(request *DescribeEdgeStatInfoRequest) (response *DescribeEdgeStatInfoResponse, err error) {
	response = CreateDescribeEdgeStatInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEdgeStatInfoWithChan invokes the lto.DescribeEdgeStatInfo API asynchronously
func (client *Client) DescribeEdgeStatInfoWithChan(request *DescribeEdgeStatInfoRequest) (<-chan *DescribeEdgeStatInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeEdgeStatInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEdgeStatInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEdgeStatInfoWithCallback invokes the lto.DescribeEdgeStatInfo API asynchronously
func (client *Client) DescribeEdgeStatInfoWithCallback(request *DescribeEdgeStatInfoRequest, callback func(response *DescribeEdgeStatInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEdgeStatInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeEdgeStatInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEdgeStatInfoRequest is the request struct for api DescribeEdgeStatInfo
type DescribeEdgeStatInfoRequest struct {
	*requests.RpcRequest
	EdgeDn string `position:"Query" name:"EdgeDn"`
	EdgePk string `position:"Query" name:"EdgePk"`
}

// DescribeEdgeStatInfoResponse is the response struct for api DescribeEdgeStatInfo
type DescribeEdgeStatInfoResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateDescribeEdgeStatInfoRequest creates a request to invoke DescribeEdgeStatInfo API
func CreateDescribeEdgeStatInfoRequest() (request *DescribeEdgeStatInfoRequest) {
	request = &DescribeEdgeStatInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "DescribeEdgeStatInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeEdgeStatInfoResponse creates a response to parse from DescribeEdgeStatInfo response
func CreateDescribeEdgeStatInfoResponse() (response *DescribeEdgeStatInfoResponse) {
	response = &DescribeEdgeStatInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
