package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDashboardMemberDeviceInfo invokes the lto.DescribeDashboardMemberDeviceInfo API synchronously
func (client *Client) DescribeDashboardMemberDeviceInfo(request *DescribeDashboardMemberDeviceInfoRequest) (response *DescribeDashboardMemberDeviceInfoResponse, err error) {
	response = CreateDescribeDashboardMemberDeviceInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDashboardMemberDeviceInfoWithChan invokes the lto.DescribeDashboardMemberDeviceInfo API asynchronously
func (client *Client) DescribeDashboardMemberDeviceInfoWithChan(request *DescribeDashboardMemberDeviceInfoRequest) (<-chan *DescribeDashboardMemberDeviceInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeDashboardMemberDeviceInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDashboardMemberDeviceInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDashboardMemberDeviceInfoWithCallback invokes the lto.DescribeDashboardMemberDeviceInfo API asynchronously
func (client *Client) DescribeDashboardMemberDeviceInfoWithCallback(request *DescribeDashboardMemberDeviceInfoRequest, callback func(response *DescribeDashboardMemberDeviceInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDashboardMemberDeviceInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeDashboardMemberDeviceInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDashboardMemberDeviceInfoRequest is the request struct for api DescribeDashboardMemberDeviceInfo
type DescribeDashboardMemberDeviceInfoRequest struct {
	*requests.RpcRequest
	EndTime   requests.Integer `position:"Query" name:"EndTime"`
	StartTime requests.Integer `position:"Query" name:"StartTime"`
}

// DescribeDashboardMemberDeviceInfoResponse is the response struct for api DescribeDashboardMemberDeviceInfo
type DescribeDashboardMemberDeviceInfoResponse struct {
	*responses.BaseResponse
	Code           string     `json:"Code" xml:"Code"`
	HttpStatusCode int        `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string     `json:"Message" xml:"Message"`
	RequestId      string     `json:"RequestId" xml:"RequestId"`
	Success        bool       `json:"Success" xml:"Success"`
	Data           []DataItem `json:"Data" xml:"Data"`
}

// CreateDescribeDashboardMemberDeviceInfoRequest creates a request to invoke DescribeDashboardMemberDeviceInfo API
func CreateDescribeDashboardMemberDeviceInfoRequest() (request *DescribeDashboardMemberDeviceInfoRequest) {
	request = &DescribeDashboardMemberDeviceInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "DescribeDashboardMemberDeviceInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDashboardMemberDeviceInfoResponse creates a response to parse from DescribeDashboardMemberDeviceInfo response
func CreateDescribeDashboardMemberDeviceInfoResponse() (response *DescribeDashboardMemberDeviceInfoResponse) {
	response = &DescribeDashboardMemberDeviceInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
