package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddBsnFabricBizChain invokes the lto.AddBsnFabricBizChain API synchronously
func (client *Client) AddBsnFabricBizChain(request *AddBsnFabricBizChainRequest) (response *AddBsnFabricBizChainResponse, err error) {
	response = CreateAddBsnFabricBizChainResponse()
	err = client.DoAction(request, response)
	return
}

// AddBsnFabricBizChainWithChan invokes the lto.AddBsnFabricBizChain API asynchronously
func (client *Client) AddBsnFabricBizChainWithChan(request *AddBsnFabricBizChainRequest) (<-chan *AddBsnFabricBizChainResponse, <-chan error) {
	responseChan := make(chan *AddBsnFabricBizChainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddBsnFabricBizChain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddBsnFabricBizChainWithCallback invokes the lto.AddBsnFabricBizChain API asynchronously
func (client *Client) AddBsnFabricBizChainWithCallback(request *AddBsnFabricBizChainRequest, callback func(response *AddBsnFabricBizChainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddBsnFabricBizChainResponse
		var err error
		defer close(result)
		response, err = client.AddBsnFabricBizChain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddBsnFabricBizChainRequest is the request struct for api AddBsnFabricBizChain
type AddBsnFabricBizChainRequest struct {
	*requests.RpcRequest
	Remark   string `position:"Query" name:"Remark"`
	Name     string `position:"Query" name:"Name"`
	AppCode  string `position:"Query" name:"AppCode"`
	NodeList string `position:"Query" name:"NodeList"`
	UserCode string `position:"Query" name:"UserCode"`
}

// AddBsnFabricBizChainResponse is the response struct for api AddBsnFabricBizChain
type AddBsnFabricBizChainResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateAddBsnFabricBizChainRequest creates a request to invoke AddBsnFabricBizChain API
func CreateAddBsnFabricBizChainRequest() (request *AddBsnFabricBizChainRequest) {
	request = &AddBsnFabricBizChainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "AddBsnFabricBizChain", "", "")
	request.Method = requests.POST
	return
}

// CreateAddBsnFabricBizChainResponse creates a response to parse from AddBsnFabricBizChain response
func CreateAddBsnFabricBizChainResponse() (response *AddBsnFabricBizChainResponse) {
	response = &AddBsnFabricBizChainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
