package ltl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCapacityInfo invokes the ltl.DescribeCapacityInfo API synchronously
func (client *Client) DescribeCapacityInfo(request *DescribeCapacityInfoRequest) (response *DescribeCapacityInfoResponse, err error) {
	response = CreateDescribeCapacityInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCapacityInfoWithChan invokes the ltl.DescribeCapacityInfo API asynchronously
func (client *Client) DescribeCapacityInfoWithChan(request *DescribeCapacityInfoRequest) (<-chan *DescribeCapacityInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeCapacityInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCapacityInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCapacityInfoWithCallback invokes the ltl.DescribeCapacityInfo API asynchronously
func (client *Client) DescribeCapacityInfoWithCallback(request *DescribeCapacityInfoRequest, callback func(response *DescribeCapacityInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCapacityInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeCapacityInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCapacityInfoRequest is the request struct for api DescribeCapacityInfo
type DescribeCapacityInfoRequest struct {
	*requests.RpcRequest
	ApiVersion string `position:"Query" name:"ApiVersion"`
	BizChainId string `position:"Query" name:"BizChainId"`
}

// DescribeCapacityInfoResponse is the response struct for api DescribeCapacityInfo
type DescribeCapacityInfoResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeCapacityInfoRequest creates a request to invoke DescribeCapacityInfo API
func CreateDescribeCapacityInfoRequest() (request *DescribeCapacityInfoRequest) {
	request = &DescribeCapacityInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ltl", "2019-05-10", "DescribeCapacityInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeCapacityInfoResponse creates a response to parse from DescribeCapacityInfo response
func CreateDescribeCapacityInfoResponse() (response *DescribeCapacityInfoResponse) {
	response = &DescribeCapacityInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
