package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetLiveMpuTaskSei invokes the live.SetLiveMpuTaskSei API synchronously
func (client *Client) SetLiveMpuTaskSei(request *SetLiveMpuTaskSeiRequest) (response *SetLiveMpuTaskSeiResponse, err error) {
	response = CreateSetLiveMpuTaskSeiResponse()
	err = client.DoAction(request, response)
	return
}

// SetLiveMpuTaskSeiWithChan invokes the live.SetLiveMpuTaskSei API asynchronously
func (client *Client) SetLiveMpuTaskSeiWithChan(request *SetLiveMpuTaskSeiRequest) (<-chan *SetLiveMpuTaskSeiResponse, <-chan error) {
	responseChan := make(chan *SetLiveMpuTaskSeiResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetLiveMpuTaskSei(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetLiveMpuTaskSeiWithCallback invokes the live.SetLiveMpuTaskSei API asynchronously
func (client *Client) SetLiveMpuTaskSeiWithCallback(request *SetLiveMpuTaskSeiRequest, callback func(response *SetLiveMpuTaskSeiResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetLiveMpuTaskSeiResponse
		var err error
		defer close(result)
		response, err = client.SetLiveMpuTaskSei(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetLiveMpuTaskSeiRequest is the request struct for api SetLiveMpuTaskSei
type SetLiveMpuTaskSeiRequest struct {
	*requests.RpcRequest
	CustomSei string `position:"Query" name:"CustomSei"`
	AppId     string `position:"Query" name:"AppId"`
	TaskId    string `position:"Query" name:"TaskId"`
}

// SetLiveMpuTaskSeiResponse is the response struct for api SetLiveMpuTaskSei
type SetLiveMpuTaskSeiResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetLiveMpuTaskSeiRequest creates a request to invoke SetLiveMpuTaskSei API
func CreateSetLiveMpuTaskSeiRequest() (request *SetLiveMpuTaskSeiRequest) {
	request = &SetLiveMpuTaskSeiRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "SetLiveMpuTaskSei", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetLiveMpuTaskSeiResponse creates a response to parse from SetLiveMpuTaskSei response
func CreateSetLiveMpuTaskSeiResponse() (response *SetLiveMpuTaskSeiResponse) {
	response = &SetLiveMpuTaskSeiResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
