package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveStreamState invokes the live.DescribeLiveStreamState API synchronously
func (client *Client) DescribeLiveStreamState(request *DescribeLiveStreamStateRequest) (response *DescribeLiveStreamStateResponse, err error) {
	response = CreateDescribeLiveStreamStateResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveStreamStateWithChan invokes the live.DescribeLiveStreamState API asynchronously
func (client *Client) DescribeLiveStreamStateWithChan(request *DescribeLiveStreamStateRequest) (<-chan *DescribeLiveStreamStateResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveStreamStateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveStreamState(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveStreamStateWithCallback invokes the live.DescribeLiveStreamState API asynchronously
func (client *Client) DescribeLiveStreamStateWithCallback(request *DescribeLiveStreamStateRequest, callback func(response *DescribeLiveStreamStateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveStreamStateResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveStreamState(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveStreamStateRequest is the request struct for api DescribeLiveStreamState
type DescribeLiveStreamStateRequest struct {
	*requests.RpcRequest
	AppName    string           `position:"Query" name:"AppName"`
	StreamName string           `position:"Query" name:"StreamName"`
	DomainName string           `position:"Query" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeLiveStreamStateResponse is the response struct for api DescribeLiveStreamState
type DescribeLiveStreamStateResponse struct {
	*responses.BaseResponse
	Type        string `json:"Type" xml:"Type"`
	RequestId   string `json:"RequestId" xml:"RequestId"`
	StreamState string `json:"StreamState" xml:"StreamState"`
}

// CreateDescribeLiveStreamStateRequest creates a request to invoke DescribeLiveStreamState API
func CreateDescribeLiveStreamStateRequest() (request *DescribeLiveStreamStateRequest) {
	request = &DescribeLiveStreamStateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveStreamState", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLiveStreamStateResponse creates a response to parse from DescribeLiveStreamState response
func CreateDescribeLiveStreamStateResponse() (response *DescribeLiveStreamStateResponse) {
	response = &DescribeLiveStreamStateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
