package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLiveStreamTranscode invokes the live.DeleteLiveStreamTranscode API synchronously
func (client *Client) DeleteLiveStreamTranscode(request *DeleteLiveStreamTranscodeRequest) (response *DeleteLiveStreamTranscodeResponse, err error) {
	response = CreateDeleteLiveStreamTranscodeResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLiveStreamTranscodeWithChan invokes the live.DeleteLiveStreamTranscode API asynchronously
func (client *Client) DeleteLiveStreamTranscodeWithChan(request *DeleteLiveStreamTranscodeRequest) (<-chan *DeleteLiveStreamTranscodeResponse, <-chan error) {
	responseChan := make(chan *DeleteLiveStreamTranscodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLiveStreamTranscode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLiveStreamTranscodeWithCallback invokes the live.DeleteLiveStreamTranscode API asynchronously
func (client *Client) DeleteLiveStreamTranscodeWithCallback(request *DeleteLiveStreamTranscodeRequest, callback func(response *DeleteLiveStreamTranscodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLiveStreamTranscodeResponse
		var err error
		defer close(result)
		response, err = client.DeleteLiveStreamTranscode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLiveStreamTranscodeRequest is the request struct for api DeleteLiveStreamTranscode
type DeleteLiveStreamTranscodeRequest struct {
	*requests.RpcRequest
	Template      string           `position:"Query" name:"Template"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	App           string           `position:"Query" name:"App"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	Domain        string           `position:"Query" name:"Domain"`
}

// DeleteLiveStreamTranscodeResponse is the response struct for api DeleteLiveStreamTranscode
type DeleteLiveStreamTranscodeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteLiveStreamTranscodeRequest creates a request to invoke DeleteLiveStreamTranscode API
func CreateDeleteLiveStreamTranscodeRequest() (request *DeleteLiveStreamTranscodeRequest) {
	request = &DeleteLiveStreamTranscodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DeleteLiveStreamTranscode", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteLiveStreamTranscodeResponse creates a response to parse from DeleteLiveStreamTranscode response
func CreateDeleteLiveStreamTranscodeResponse() (response *DeleteLiveStreamTranscodeResponse) {
	response = &DeleteLiveStreamTranscodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
