package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateRoomRealTimeStreamAddress invokes the live.CreateRoomRealTimeStreamAddress API synchronously
func (client *Client) CreateRoomRealTimeStreamAddress(request *CreateRoomRealTimeStreamAddressRequest) (response *CreateRoomRealTimeStreamAddressResponse, err error) {
	response = CreateCreateRoomRealTimeStreamAddressResponse()
	err = client.DoAction(request, response)
	return
}

// CreateRoomRealTimeStreamAddressWithChan invokes the live.CreateRoomRealTimeStreamAddress API asynchronously
func (client *Client) CreateRoomRealTimeStreamAddressWithChan(request *CreateRoomRealTimeStreamAddressRequest) (<-chan *CreateRoomRealTimeStreamAddressResponse, <-chan error) {
	responseChan := make(chan *CreateRoomRealTimeStreamAddressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateRoomRealTimeStreamAddress(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateRoomRealTimeStreamAddressWithCallback invokes the live.CreateRoomRealTimeStreamAddress API asynchronously
func (client *Client) CreateRoomRealTimeStreamAddressWithCallback(request *CreateRoomRealTimeStreamAddressRequest, callback func(response *CreateRoomRealTimeStreamAddressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateRoomRealTimeStreamAddressResponse
		var err error
		defer close(result)
		response, err = client.CreateRoomRealTimeStreamAddress(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateRoomRealTimeStreamAddressRequest is the request struct for api CreateRoomRealTimeStreamAddress
type CreateRoomRealTimeStreamAddressRequest struct {
	*requests.RpcRequest
	ExpireTime  requests.Integer `position:"Query" name:"ExpireTime"`
	UserId      string           `position:"Query" name:"UserId"`
	AppId       string           `position:"Query" name:"AppId"`
	DisplayName string           `position:"Query" name:"DisplayName"`
	ChannelId   string           `position:"Query" name:"ChannelId"`
}

// CreateRoomRealTimeStreamAddressResponse is the response struct for api CreateRoomRealTimeStreamAddress
type CreateRoomRealTimeStreamAddressResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	RtmpAddress string `json:"RtmpAddress" xml:"RtmpAddress"`
}

// CreateCreateRoomRealTimeStreamAddressRequest creates a request to invoke CreateRoomRealTimeStreamAddress API
func CreateCreateRoomRealTimeStreamAddressRequest() (request *CreateRoomRealTimeStreamAddressRequest) {
	request = &CreateRoomRealTimeStreamAddressRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "CreateRoomRealTimeStreamAddress", "live", "openAPI")
	request.Method = requests.GET
	return
}

// CreateCreateRoomRealTimeStreamAddressResponse creates a response to parse from CreateRoomRealTimeStreamAddress response
func CreateCreateRoomRealTimeStreamAddressResponse() (response *CreateRoomRealTimeStreamAddressResponse) {
	response = &CreateRoomRealTimeStreamAddressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
