package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetLocalConfigSyncTask invokes the linkwan.GetLocalConfigSyncTask API synchronously
func (client *Client) GetLocalConfigSyncTask(request *GetLocalConfigSyncTaskRequest) (response *GetLocalConfigSyncTaskResponse, err error) {
	response = CreateGetLocalConfigSyncTaskResponse()
	err = client.DoAction(request, response)
	return
}

// GetLocalConfigSyncTaskWithChan invokes the linkwan.GetLocalConfigSyncTask API asynchronously
func (client *Client) GetLocalConfigSyncTaskWithChan(request *GetLocalConfigSyncTaskRequest) (<-chan *GetLocalConfigSyncTaskResponse, <-chan error) {
	responseChan := make(chan *GetLocalConfigSyncTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetLocalConfigSyncTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetLocalConfigSyncTaskWithCallback invokes the linkwan.GetLocalConfigSyncTask API asynchronously
func (client *Client) GetLocalConfigSyncTaskWithCallback(request *GetLocalConfigSyncTaskRequest, callback func(response *GetLocalConfigSyncTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetLocalConfigSyncTaskResponse
		var err error
		defer close(result)
		response, err = client.GetLocalConfigSyncTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetLocalConfigSyncTaskRequest is the request struct for api GetLocalConfigSyncTask
type GetLocalConfigSyncTaskRequest struct {
	*requests.RpcRequest
	ApiProduct  string           `position:"Body" name:"ApiProduct"`
	ApiRevision string           `position:"Body" name:"ApiRevision"`
	TaskId      requests.Integer `position:"Query" name:"TaskId"`
}

// GetLocalConfigSyncTaskResponse is the response struct for api GetLocalConfigSyncTask
type GetLocalConfigSyncTaskResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateGetLocalConfigSyncTaskRequest creates a request to invoke GetLocalConfigSyncTask API
func CreateGetLocalConfigSyncTaskRequest() (request *GetLocalConfigSyncTaskRequest) {
	request = &GetLocalConfigSyncTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "GetLocalConfigSyncTask", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetLocalConfigSyncTaskResponse creates a response to parse from GetLocalConfigSyncTask response
func CreateGetLocalConfigSyncTaskResponse() (response *GetLocalConfigSyncTaskResponse) {
	response = &GetLocalConfigSyncTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
