package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TriggerCapturePicture invokes the linkvisual.TriggerCapturePicture API synchronously
func (client *Client) TriggerCapturePicture(request *TriggerCapturePictureRequest) (response *TriggerCapturePictureResponse, err error) {
	response = CreateTriggerCapturePictureResponse()
	err = client.DoAction(request, response)
	return
}

// TriggerCapturePictureWithChan invokes the linkvisual.TriggerCapturePicture API asynchronously
func (client *Client) TriggerCapturePictureWithChan(request *TriggerCapturePictureRequest) (<-chan *TriggerCapturePictureResponse, <-chan error) {
	responseChan := make(chan *TriggerCapturePictureResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TriggerCapturePicture(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TriggerCapturePictureWithCallback invokes the linkvisual.TriggerCapturePicture API asynchronously
func (client *Client) TriggerCapturePictureWithCallback(request *TriggerCapturePictureRequest, callback func(response *TriggerCapturePictureResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TriggerCapturePictureResponse
		var err error
		defer close(result)
		response, err = client.TriggerCapturePicture(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TriggerCapturePictureRequest is the request struct for api TriggerCapturePicture
type TriggerCapturePictureRequest struct {
	*requests.RpcRequest
	IotId         string `position:"Query" name:"IotId"`
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	ProductKey    string `position:"Query" name:"ProductKey"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
	DeviceName    string `position:"Query" name:"DeviceName"`
}

// TriggerCapturePictureResponse is the response struct for api TriggerCapturePicture
type TriggerCapturePictureResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	Data         string `json:"Data" xml:"Data"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateTriggerCapturePictureRequest creates a request to invoke TriggerCapturePicture API
func CreateTriggerCapturePictureRequest() (request *TriggerCapturePictureRequest) {
	request = &TriggerCapturePictureRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "TriggerCapturePicture", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateTriggerCapturePictureResponse creates a response to parse from TriggerCapturePicture response
func CreateTriggerCapturePictureResponse() (response *TriggerCapturePictureResponse) {
	response = &TriggerCapturePictureResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
