package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteFaceUserPicture invokes the linkvisual.DeleteFaceUserPicture API synchronously
func (client *Client) DeleteFaceUserPicture(request *DeleteFaceUserPictureRequest) (response *DeleteFaceUserPictureResponse, err error) {
	response = CreateDeleteFaceUserPictureResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteFaceUserPictureWithChan invokes the linkvisual.DeleteFaceUserPicture API asynchronously
func (client *Client) DeleteFaceUserPictureWithChan(request *DeleteFaceUserPictureRequest) (<-chan *DeleteFaceUserPictureResponse, <-chan error) {
	responseChan := make(chan *DeleteFaceUserPictureResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteFaceUserPicture(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteFaceUserPictureWithCallback invokes the linkvisual.DeleteFaceUserPicture API asynchronously
func (client *Client) DeleteFaceUserPictureWithCallback(request *DeleteFaceUserPictureRequest, callback func(response *DeleteFaceUserPictureResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteFaceUserPictureResponse
		var err error
		defer close(result)
		response, err = client.DeleteFaceUserPicture(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteFaceUserPictureRequest is the request struct for api DeleteFaceUserPicture
type DeleteFaceUserPictureRequest struct {
	*requests.RpcRequest
	IsolationId string `position:"Query" name:"IsolationId"`
	UserId      string `position:"Query" name:"UserId"`
	ApiProduct  string `position:"Body" name:"ApiProduct"`
	ApiRevision string `position:"Body" name:"ApiRevision"`
	FacePicMd5  string `position:"Query" name:"FacePicMd5"`
}

// DeleteFaceUserPictureResponse is the response struct for api DeleteFaceUserPicture
type DeleteFaceUserPictureResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateDeleteFaceUserPictureRequest creates a request to invoke DeleteFaceUserPicture API
func CreateDeleteFaceUserPictureRequest() (request *DeleteFaceUserPictureRequest) {
	request = &DeleteFaceUserPictureRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "DeleteFaceUserPicture", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteFaceUserPictureResponse creates a response to parse from DeleteFaceUserPicture response
func CreateDeleteFaceUserPictureResponse() (response *DeleteFaceUserPictureResponse) {
	response = &DeleteFaceUserPictureResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
