package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckFaceUserDoExistOnDevice invokes the linkvisual.CheckFaceUserDoExistOnDevice API synchronously
func (client *Client) CheckFaceUserDoExistOnDevice(request *CheckFaceUserDoExistOnDeviceRequest) (response *CheckFaceUserDoExistOnDeviceResponse, err error) {
	response = CreateCheckFaceUserDoExistOnDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// CheckFaceUserDoExistOnDeviceWithChan invokes the linkvisual.CheckFaceUserDoExistOnDevice API asynchronously
func (client *Client) CheckFaceUserDoExistOnDeviceWithChan(request *CheckFaceUserDoExistOnDeviceRequest) (<-chan *CheckFaceUserDoExistOnDeviceResponse, <-chan error) {
	responseChan := make(chan *CheckFaceUserDoExistOnDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckFaceUserDoExistOnDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckFaceUserDoExistOnDeviceWithCallback invokes the linkvisual.CheckFaceUserDoExistOnDevice API asynchronously
func (client *Client) CheckFaceUserDoExistOnDeviceWithCallback(request *CheckFaceUserDoExistOnDeviceRequest, callback func(response *CheckFaceUserDoExistOnDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckFaceUserDoExistOnDeviceResponse
		var err error
		defer close(result)
		response, err = client.CheckFaceUserDoExistOnDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckFaceUserDoExistOnDeviceRequest is the request struct for api CheckFaceUserDoExistOnDevice
type CheckFaceUserDoExistOnDeviceRequest struct {
	*requests.RpcRequest
	IsolationId   string `position:"Query" name:"IsolationId"`
	UserId        string `position:"Query" name:"UserId"`
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	ProductKey    string `position:"Query" name:"ProductKey"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
	DeviceName    string `position:"Query" name:"DeviceName"`
}

// CheckFaceUserDoExistOnDeviceResponse is the response struct for api CheckFaceUserDoExistOnDevice
type CheckFaceUserDoExistOnDeviceResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateCheckFaceUserDoExistOnDeviceRequest creates a request to invoke CheckFaceUserDoExistOnDevice API
func CreateCheckFaceUserDoExistOnDeviceRequest() (request *CheckFaceUserDoExistOnDeviceRequest) {
	request = &CheckFaceUserDoExistOnDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "CheckFaceUserDoExistOnDevice", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCheckFaceUserDoExistOnDeviceResponse creates a response to parse from CheckFaceUserDoExistOnDevice response
func CreateCheckFaceUserDoExistOnDeviceResponse() (response *CheckFaceUserDoExistOnDeviceResponse) {
	response = &CheckFaceUserDoExistOnDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
